/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.bundledviewer;

import mods.immibis.redlogic.api.wiring.IBundledEmitter;
import mods.immibis.redlogic.api.wiring.IBundledUpdatable;
import mods.immibis.redlogic.api.wiring.IConnectable;
import mods.immibis.redlogic.api.wiring.IWire;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class BundledViewerTileEntity
extends TileEntity
implements IConnectable,
IBundledUpdatable {
    byte[] signals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public byte[] getSignals() {
        return this.signals;
    }

    public void onBundledInputChanged() {
        this.signals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof IBundledEmitter) {
                IBundledEmitter emitter = (IBundledEmitter)te;
                for (int i = -1; i <= 5; ++i) {
                    byte[] newState = emitter.getBundledCableStrength(i, dir.getOpposite().ordinal());
                    if (newState == null) continue;
                    for (int c = 0; c < newState.length; ++c) {
                        int n = c;
                        this.signals[n] = (byte)(this.signals[n] | newState[c]);
                    }
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.signals = pkt.func_148857_g().func_74770_j("SIGNALS");
        if (this.signals.length != 16) {
            this.signals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public boolean connects(IWire wire, int blockFace, int fromDirection) {
        return true;
    }

    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return true;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74773_a("SIGNALS", this.signals);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.signals = tag.func_74770_j("SIGNALS");
        if (this.signals.length != 16) {
            this.signals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
    }
}

