/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.bundledviewer;

import com.bymarcin.zettaindustries.mods.bundledviewer.BundledViewerTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class BundledViewerRenderer
extends TileEntitySpecialRenderer {
    final float angle90 = (float)Math.toRadians(90.0);
    final float angle180 = (float)Math.toRadians(180.0);
    final float angle270 = (float)Math.toRadians(-90.0);
    Matrix4f[] rotationMatrix = new Matrix4f[ForgeDirection.VALID_DIRECTIONS.length];
    Quad[] vertices;
    ResourceLocation rl = new ResourceLocation("zettaindustries", "textures/blocks/empty.png");

    public BundledViewerRenderer() {
        this.init();
    }

    public void init() {
        for (ForgeDirection fdir : ForgeDirection.VALID_DIRECTIONS) {
            Matrix4f m = new Matrix4f();
            m = m.translate(new Vector3f(0.5f, 0.5f, 0.5f), m);
            switch (fdir) {
                case DOWN: {
                    m.rotate(this.angle180, new Vector3f(0.0f, 1.0f, 0.0f));
                    m.rotate(this.angle270, new Vector3f(1.0f, 0.0f, 0.0f));
                    break;
                }
                case NORTH: {
                    break;
                }
                case EAST: {
                    m.rotate(this.angle270, new Vector3f(0.0f, 1.0f, 0.0f));
                    break;
                }
                case WEST: {
                    m.rotate(this.angle90, new Vector3f(0.0f, 1.0f, 0.0f));
                    break;
                }
                case SOUTH: {
                    m.rotate(this.angle180, new Vector3f(0.0f, 1.0f, 0.0f));
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                case UP: {
                    m.rotate(this.angle90, new Vector3f(0.0f, 0.0f, 1.0f));
                    m.rotate(this.angle90, new Vector3f(1.0f, 0.0f, 0.0f));
                    m.rotate(this.angle270, new Vector3f(0.0f, 1.0f, 0.0f));
                    break;
                }
            }
            this.rotationMatrix[fdir.ordinal()] = m = m.translate(new Vector3f(-0.5f, -0.5f, -0.5f), m);
        }
        ArrayList<Quad> vertices = new ArrayList<Quad>();
        float offsetX = 0.03125f;
        float offsetY = -0.21875f;
        for (int i = 16; i > 0; --i) {
            if (i % 4 == 0) {
                offsetX = 0.03125f;
                offsetY += 0.25f;
            }
            Quad q = new Quad();
            q.setVertices(0, new Vector4f(offsetX + 0.0f, offsetY + 0.0f, -0.001f, 1.0f));
            q.setVertices(1, new Vector4f(offsetX + 0.0f, offsetY + 0.1875f, -0.001f, 1.0f));
            q.setVertices(2, new Vector4f(offsetX + 0.1875f, offsetY + 0.1875f, -0.001f, 1.0f));
            q.setVertices(3, new Vector4f(offsetX + 0.1875f, offsetY + 0.0f, -0.001f, 1.0f));
            vertices.add(q);
            offsetX += 0.25f;
        }
        Collections.reverse(vertices);
        this.vertices = vertices.toArray(new Quad[0]);
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float t) {
        byte[] signals = ((BundledViewerTileEntity)te).getSignals();
        this.func_147499_a(this.rl);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        for (int i = 0; i < signals.length; ++i) {
            if (signals[i] != 0) {
                Tessellator.field_78398_a.func_78369_a(EntitySheep.field_70898_d[i][0] * 1.1f, EntitySheep.field_70898_d[i][1] * 1.1f, EntitySheep.field_70898_d[i][2] * 1.1f, 1.0f);
            } else {
                Tessellator.field_78398_a.func_78369_a(EntitySheep.field_70898_d[i][0] * 0.2f, EntitySheep.field_70898_d[i][1] * 0.2f, EntitySheep.field_70898_d[i][2] * 0.2f, 1.0f);
            }
            for (int dir = 1; dir < 6; ++dir) {
                Matrix4f m = this.rotationMatrix[dir];
                for (int k = 0; k < 4; ++k) {
                    Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                    Vector4f result = Matrix4f.transform((Matrix4f)m, (Vector4f)new Vector4f(this.vertices[i].getVertices()[k].x, this.vertices[i].getVertices()[k].y, this.vertices[i].getVertices()[k].z, 1.0f), null);
                    Tessellator.field_78398_a.func_78377_a((double)result.x, (double)result.y, (double)result.z);
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    static class Quad {
        Vector4f[] vertices = new Vector4f[4];

        Quad() {
        }

        public void setVertices(int index, Vector4f vec) {
            this.vertices[index] = vec;
        }

        public void draw(Tessellator tes) {
            for (int i = 0; i < this.vertices.length; ++i) {
                tes.func_78377_a((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z);
            }
        }

        public Vector4f[] getVertices() {
            return this.vertices;
        }
    }
}

