/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.transport.IPipeTransportFluidsHook;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeLiquidsTeleport
extends PipeTeleport<PipeTransportFluids>
implements IPipeTransportFluidsHook {
    private static final int ICON = 2;

    public PipeLiquidsTeleport(Item item) {
        super(new PipeTransportFluids(), item, PipeType.FLUIDS);
        ((PipeTransportFluids)this.transport).initFromPipe(PipeFluidsDiamond.class);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        ArrayList<PipeLiquidsTeleport> pipeList = TeleportManager.instance.getConnectedPipes(this, false, true);
        if (pipeList.size() == 0 || (this.state & 1) == 0) {
            return 0;
        }
        int i = this.getWorld().field_73012_v.nextInt(pipeList.size());
        List<IFluidHandler> possibleMovements = PipeLiquidsTeleport.getPossibleLiquidMovements((PipeTeleport)pipeList.get(i));
        if (possibleMovements.size() <= 0) {
            return 0;
        }
        int used = 0;
        while (possibleMovements.size() > 0 && used <= 0) {
            int a = rand.nextInt(possibleMovements.size());
            used = possibleMovements.get(a).fill(ForgeDirection.UNKNOWN, resource, doFill);
            possibleMovements.remove(a);
        }
        return used;
    }

    private static List<IFluidHandler> getPossibleLiquidMovements(PipeTeleport<?> pipe) {
        LinkedList<IFluidHandler> result = new LinkedList<IFluidHandler>();
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            IFluidHandler te;
            if (!pipe.outputOpen(o) || (te = (IFluidHandler)pipe.container.getTile(o)) == null) continue;
            result.add(te);
        }
        return result;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 2;
    }
}

