/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.configuration.ToolType;
import portablejim.veinminer.core.CoreEvents;
import portablejim.veinminer.lib.MinerLogger;
import portablejim.veinminer.lib.ModInfo;
import portablejim.veinminer.network.PacketChangeMode;
import portablejim.veinminer.network.PacketClientPresent;
import portablejim.veinminer.network.PacketMinerActivate;
import portablejim.veinminer.network.PacketPingClient;
import portablejim.veinminer.proxy.CommonProxy;
import portablejim.veinminer.server.MinerCommand;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.BlockID;

@Mod(modid="VeinMiner", acceptedMinecraftVersions="[1.7,1.8)", canBeDeactivated=true, guiFactory="portablejim.veinminer.configuration.client.ConfigGuiFactory")
public class VeinMiner {
    @Mod.Instance(value="VeinMiner")
    public static VeinMiner instance;
    @SidedProxy(clientSide="portablejim.veinminer.proxy.ClientProxy", serverSide="portablejim.veinminer.proxy.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper networkWrapper;
    ConfigurationValues configurationValues;
    public ConfigurationSettings configurationSettings;
    public MinerServer minerServer = null;
    public int currentMode = 0;
    public Logger logger;

    @NetworkCheckHandler
    public boolean checkClientModVersion(Map<String, String> mods, Side side) {
        FMLLog.fine((String)"Check Version", (Object[])new Object[0]);
        if (mods.size() == 0) {
            return true;
        }
        if (mods.containsKey("VeinMiner")) {
            String[] splitOurVersion;
            String clientVersion = mods.get("VeinMiner");
            String ourVersionString = ((ModContainer)Loader.instance().getIndexedModList().get("VeinMiner")).getVersion();
            if (ourVersionString.equals(clientVersion) || ourVersionString.startsWith("${version}") || clientVersion.startsWith("${version}")) {
                return true;
            }
            int clientMajor = 0;
            int clientMinor = 0;
            int major = 0;
            int minor = 0;
            String[] splitVersion = clientVersion.split("\\.");
            if (splitVersion.length >= 2) {
                clientMajor = Integer.parseInt(splitVersion[0]);
                clientMinor = Integer.parseInt(splitVersion[1]);
            }
            if ((splitOurVersion = ourVersionString.split("\\.")).length >= 2) {
                major = Integer.parseInt(splitOurVersion[0]);
                minor = Integer.parseInt(splitOurVersion[1]);
            }
            return !(major != clientMajor || major == 0 && minor != clientMinor || major == 0 && minor == 0);
        }
        if (side == Side.CLIENT && !mods.containsKey("VeinMiner")) {
            return true;
        }
        if (side == Side.SERVER && !mods.containsKey("VeinMiner")) {
            return true;
        }
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.setupNetworking();
        File modDir = new File(event.getModConfigurationDirectory(), "veinminer");
        if (!modDir.exists()) {
            modDir.mkdir();
        }
        this.configurationValues = new ConfigurationValues(new File(modDir, "general.cfg"), new File(modDir, "tools-and-blocks.json"));
        this.configurationValues.loadConfigFile();
        this.configurationSettings = new ConfigurationSettings(this.configurationValues);
        proxy.registerClientEvents();
        proxy.registerCommonEvents();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CoreEvents());
    }

    public void setupNetworking() {
        this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("VeinMiner");
        this.networkWrapper.registerMessage(PacketPingClient.Handler.class, PacketPingClient.class, 0, Side.CLIENT);
        this.networkWrapper.registerMessage(PacketClientPresent.Handler.class, PacketClientPresent.class, 1, Side.SERVER);
        this.networkWrapper.registerMessage(PacketMinerActivate.Handler.class, PacketMinerActivate.class, 2, Side.SERVER);
        this.networkWrapper.registerMessage(PacketChangeMode.Handler.class, PacketChangeMode.class, 3, Side.CLIENT);
        this.networkWrapper.registerMessage(PacketChangeMode.Handler.class, PacketChangeMode.class, 4, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String fileName;
        ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("VeinMiner");
        if (thisMod != null && ((fileName = thisMod.getSource().getName()).contains("-dev") || !fileName.contains(".jar"))) {
            ModInfo.DEBUG_MODE = true;
            MinerLogger.debug("Enabling debug mode", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] oreDictList = OreDictionary.getOreNames();
        for (ToolType toolTypeEnum : ToolType.values()) {
            Set<String> autodetectValues = this.configurationSettings.getAutodetectBlocksList(toolTypeEnum);
            if (!this.configurationSettings.getAutodetectBlocksToggle(toolTypeEnum)) continue;
            String[] toolTypeLookup = new String[]{"axe", "hoe", "pickaxe", "shears", "shovel"};
            String toolType = toolTypeLookup[toolTypeEnum.ordinal()];
            for (String oreDictEntry : oreDictList) {
                for (String autodetectValue : autodetectValues) {
                    if (autodetectValue.isEmpty() || !oreDictEntry.startsWith(autodetectValue)) continue;
                    ArrayList itemStacks = OreDictionary.getOres((String)oreDictEntry);
                    for (ItemStack item : itemStacks) {
                        if (!(item.func_77973_b() instanceof ItemBlock)) continue;
                        String blockName = Item.field_150901_e.func_148750_c((Object)item.func_77973_b());
                        if (blockName != null) {
                            this.configurationSettings.addBlockToWhitelist(toolType, new BlockID(blockName, item.func_77960_j()));
                        }
                        try {
                            MinerLogger.debug("Adding %s/%d (%s) to block whitelist for %s (%s:%s)", blockName, item.func_77960_j(), item.func_82833_r(), toolType, autodetectValue, oreDictEntry);
                        }
                        catch (Exception e) {
                            this.logger.error("ERROR while looking at block with name %d. This is a bug with the respective mod.", new Object[]{blockName});
                            this.logger.catching((Throwable)e);
                        }
                    }
                }
            }
        }
        this.configurationSettings.saveConfigs();
        proxy.registerPostinitCommands();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.minerServer = new MinerServer(this.configurationValues);
        proxy.setMinerServer(this.minerServer);
        ServerCommandManager serverCommandManger = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        serverCommandManger.func_71560_a((ICommand)new MinerCommand(this.minerServer));
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            NBTTagCompound nbtMessage;
            if ("whitelist".equalsIgnoreCase(message.key) && message.isNBTMessage()) {
                nbtMessage = message.getNBTValue();
                String whitelistName = nbtMessage.func_74779_i("whitelistType");
                String toolType = nbtMessage.func_74779_i("toolType");
                String toolName = nbtMessage.func_74779_i("blockName");
                if (!this.configurationSettings.getToolTypeNames().contains(toolType)) {
                    MinerLogger.debug("Tool %s does not exist. Cannot add %s", toolType, toolName);
                    continue;
                }
                if ("block".equalsIgnoreCase(whitelistName)) {
                    BlockID blockName = new BlockID(toolName);
                    MinerLogger.debug("Adding block %s %s to whitelist because of IMC", toolType, blockName.toString());
                    this.configurationSettings.addBlockToWhitelist(toolType, blockName);
                } else if ("item".equalsIgnoreCase(whitelistName)) {
                    MinerLogger.debug("Adding item/tool %s %s to whitelist because of IMC", toolType, toolName);
                    this.configurationSettings.addTool(toolType, toolName);
                }
                this.configurationSettings.saveConfigs();
                continue;
            }
            if ("addTool".equalsIgnoreCase(message.key) && message.isNBTMessage()) {
                nbtMessage = message.getNBTValue();
                String newToolType = nbtMessage.func_74779_i("toolType");
                String newToolName = nbtMessage.func_74779_i("toolName");
                String newToolIcon = nbtMessage.func_74779_i("toolIcon");
                MinerLogger.debug("Adding '%s' (Name: '%s' Icon: '%s')as a tool", newToolType, newToolName, newToolIcon);
                this.configurationSettings.addToolType(newToolType, newToolName, newToolIcon);
                this.configurationSettings.saveConfigs();
                continue;
            }
            if (!"addEqualBlocks".equalsIgnoreCase(message.key) || !message.isNBTMessage()) continue;
            nbtMessage = message.getNBTValue();
            String block1 = nbtMessage.func_74779_i("existingBlock");
            String block2 = nbtMessage.func_74779_i("newBlock");
            this.configurationSettings.addCongruentBlocks(block1, block2);
        }
    }
}

