/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import sonar.calculator.mod.api.flux.IFlux;
import sonar.calculator.mod.api.flux.IFluxController;
import sonar.calculator.mod.api.flux.IFluxPlug;
import sonar.calculator.mod.api.flux.IFluxPoint;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.calculator.mod.utils.FluxRegistry;

public class FluxHelper {
    public static TileEntity getTile(IFlux flux) {
        if (flux == null) {
            return null;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer world = server.func_71218_a(flux.dimension());
        if (world != null) {
            TileEntity target = world.func_147438_o(flux.xCoord(), flux.yCoord(), flux.zCoord());
            return target;
        }
        return null;
    }

    public static IFluxPoint getPoint(IFlux flux) {
        TileEntity target = FluxHelper.getTile(flux);
        if (target != null && target instanceof IFluxPoint) {
            return (IFluxPoint)target;
        }
        return null;
    }

    public static IFluxPlug getPlug(IFlux flux) {
        TileEntity target = FluxHelper.getTile(flux);
        if (target != null && target instanceof IFluxPlug) {
            return (IFluxPlug)target;
        }
        return null;
    }

    public static IFluxController getController(int networkID) {
        TileEntity target = FluxHelper.getTile(FluxRegistry.getController(networkID));
        if (target != null && target instanceof IFluxController) {
            return (IFluxController)target;
        }
        return null;
    }

    public static List<IFluxPoint> getPoints(int networkID) {
        List<IFlux> fluxList = FluxRegistry.getPoints(networkID);
        if (fluxList == null) {
            return null;
        }
        ArrayList<IFluxPoint> points = new ArrayList<IFluxPoint>();
        for (int i = 0; i < fluxList.size(); ++i) {
            IFluxPoint point = FluxHelper.getPoint(fluxList.get(i));
            if (point == null || point.networkID() != networkID) continue;
            points.add(point);
        }
        Collections.sort(points, new Comparator<IFluxPoint>(){

            @Override
            public int compare(IFluxPoint o1, IFluxPoint o2) {
                return o2.priority() - o1.priority();
            }
        });
        return points;
    }

    public static List<IFluxPlug> getPlugs(int networkID) {
        List<IFlux> fluxList = FluxRegistry.getPlugs(networkID);
        if (fluxList == null || fluxList.size() == 0) {
            return null;
        }
        ArrayList<IFluxPlug> plugs = new ArrayList<IFluxPlug>();
        for (int i = 0; i < fluxList.size(); ++i) {
            IFluxPlug plug = FluxHelper.getPlug(fluxList.get(i));
            if (plug == null || plug.networkID() != networkID) continue;
            plugs.add(plug);
        }
        IFluxController controller = FluxHelper.getController(networkID);
        if (controller == null || controller != null && controller.getSendMode() == 0) {
            return plugs;
        }
        if (controller.getSendMode() == 2) {
            Collections.sort(plugs, new Comparator<IFluxPlug>(){

                @Override
                public int compare(IFluxPlug o1, IFluxPlug o2) {
                    return o2.pullEnergy(2000000000, true, true) - o1.pullEnergy(2000000000, true, true);
                }
            });
            return plugs;
        }
        Collections.sort(plugs, new Comparator<IFluxPlug>(){

            @Override
            public int compare(IFluxPlug o1, IFluxPlug o2) {
                return o1.pullEnergy(2000000000, true, true) - o2.pullEnergy(2000000000, true, true);
            }
        });
        return plugs;
    }

    public static int getMaxOutput(int networkID) {
        List<IFlux> points = FluxRegistry.getPoints(networkID);
        int output = 0;
        if (points == null || points.size() == 0) {
            return 0;
        }
        for (int i = 0; i < points.size(); ++i) {
            TileEntity target;
            if (points.get(i) == null || (target = FluxHelper.getTile(points.get(i))) == null || !(target instanceof IFluxPoint)) continue;
            IFluxPoint point = (IFluxPoint)target;
            int transfer = Math.min(2000000000, point.maxTransfer());
            output += transfer - point.pushEnergy(transfer, true);
        }
        return output;
    }

    public static TileEntityFlux.TransferList getMaxInput(int networkID) {
        List<IFluxPlug> plugs = FluxHelper.getPlugs(networkID);
        if (plugs == null || plugs.size() == 0) {
            return new TileEntityFlux.TransferList(new int[0], 0);
        }
        int input = 0;
        int[] inputList = new int[plugs.size()];
        for (int i = 0; i < plugs.size(); ++i) {
            input += 2000000000 - plugs.get(i).pullEnergy(2000000000, true, false);
            inputList[i] = 2000000000 - plugs.get(i).pullEnergy(2000000000, true, true);
        }
        return new TileEntityFlux.TransferList(inputList, input);
    }

    public static long getBuffer(int networkID) {
        List<IFluxPlug> plugs = FluxHelper.getPlugs(networkID);
        if (plugs == null || plugs.size() == 0) {
            return 0L;
        }
        long buffer = 0L;
        int[] inputList = new int[plugs.size()];
        for (int i = 0; i < plugs.size(); ++i) {
            buffer += (long)(2000000000 - plugs.get(i).getBuffer(2000000000, true));
        }
        return buffer;
    }

    public static boolean checkPlayerName(String player, int networkID) {
        IFluxController controller = FluxHelper.getController(networkID);
        if (controller == null) {
            return true;
        }
        return controller.validPlayer(player);
    }

    public static boolean checkPlayerName(TileEntity flux, int networkName) {
        if (flux == null || !(flux instanceof TileEntityFlux)) {
            return true;
        }
        IFluxController controller = FluxHelper.getController(networkName);
        if (controller == null) {
            return true;
        }
        return controller.validPlayer((String)((TileEntityFlux)flux).playerName.getObject());
    }
}

