/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils.helpers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.common.block.CalculatorLeaves;
import sonar.calculator.mod.common.block.CalculatorLogs;
import sonar.calculator.mod.common.block.CalculatorSaplings;

public class CalculatorTreeBuilder
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final int metaWood;
    private final int metaLeaves;
    private CalculatorSaplings sapling;
    private CalculatorLeaves blockLeaves;
    private CalculatorLogs blockLog;
    private static Random rand = new Random();

    public CalculatorTreeBuilder(boolean par1, Block sapling, Block blockLeaves, Block blockLog) {
        this(par1, 4 + rand.nextInt(2), 3, 3, false, (CalculatorSaplings)sapling, (CalculatorLeaves)blockLeaves, (CalculatorLogs)blockLog);
    }

    public CalculatorTreeBuilder(boolean par1, int height, int wood, int leaves, boolean vines, CalculatorSaplings sapling, CalculatorLeaves blockLeaves, CalculatorLogs blockLog) {
        super(par1);
        this.minTreeHeight = height;
        this.metaWood = wood;
        this.metaLeaves = leaves;
        this.vinesGrow = vines;
        this.sapling = sapling;
        this.blockLeaves = blockLeaves;
        this.blockLog = blockLog;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int l = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (y >= 1 && y + l + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = y; i1 <= y + 1 + l; ++i1) {
                b0 = 1;
                if (i1 == y) {
                    b0 = 0;
                }
                if (i1 >= y + 1 + l - 2) {
                    b0 = 2;
                }
                for (int j1 = x - b0; j1 <= x + b0 && flag; ++j1) {
                    for (k1 = z - b0; k1 <= z + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = world.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(world, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this.sapling);
            if (isSoil && y < 256 - l - 1) {
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                b0 = 3;
                int b1 = 0;
                for (k1 = y - b0 + l; k1 <= y + l; ++k1) {
                    int i3 = k1 - (y + l);
                    int l1 = b1 + 1 - i3 / 2;
                    for (int i2 = x - l1; i2 <= x + l1; ++i2) {
                        int j2 = i2 - x;
                        for (int k2 = z - l1; k2 <= z + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - z;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (rand.nextInt(2) == 0 || i3 == 0) || !(block1 = world.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)world, i2, k1, k2) && !block1.isLeaves((IBlockAccess)world, i2, k1, k2)) continue;
                            world.func_147449_b(i2, k1, k2, (Block)this.blockLeaves);
                        }
                    }
                }
                for (k1 = 0; k1 < l; ++k1) {
                    block = world.func_147439_a(x, y + k1, z);
                    if (!block.isAir((IBlockAccess)world, x, y + k1, z) && !block.isLeaves((IBlockAccess)world, x, y + k1, z)) continue;
                    world.func_147449_b(x, y + k1, z, (Block)this.blockLog);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growVines(World world, int x, int y, int z, int flag) {
        this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        int i1 = 4;
        while (!world.func_147439_a(x, --y, z).isAir((IBlockAccess)world, x, y, z) && i1 > 0) {
            this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
            --i1;
        }
        return;
    }
}

