/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BigStack {
    public int maxStacks;
    public int currentStackSize;
    public int maxStackSize;
    public ItemStack stack;

    public BigStack() {
    }

    public BigStack(int max, int current, ItemStack stack) {
        this.maxStacks = max;
        this.stack = stack;
        this.currentStackSize = current;
        this.maxStackSize = stack.func_77976_d() * this.maxStacks;
    }

    public BigStack(int max, ItemStack stack) {
        this.maxStacks = max;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("maxStacks", this.maxStacks);
        tag.func_74768_a("currentStackSize", this.currentStackSize);
        if (this.stack != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.stack.func_77955_b(item);
            tag.func_74782_a("stack", (NBTBase)item);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.maxStacks = tag.func_74762_e("maxStacks");
        this.currentStackSize = tag.func_74762_e("currentStackSize");
        this.stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("stack"));
        if (this.stack != null) {
            this.maxStackSize *= this.stack.func_77976_d();
        }
    }

    public ItemStack removeStack(int derc) {
        int size;
        if (this.stack == null || this.currentStackSize == 0) {
            return null;
        }
        ItemStack remove = this.stack.func_77946_l();
        remove.field_77994_a = size = Math.min(this.currentStackSize, Math.min(this.stack.func_77976_d(), derc));
        this.currentStackSize -= size;
        if (this.currentStackSize <= 0) {
            this.stack = null;
            this.maxStackSize = 0;
            this.currentStackSize = 0;
        }
        return remove;
    }

    public ItemStack addStack(ItemStack stack) {
        if (this.canAddStack(stack) && (this.maxStackSize == 0 || this.currentStackSize < this.maxStackSize)) {
            if (this.stack == null) {
                this.setItemStack(stack);
            }
            int size = Math.min(stack.field_77994_a, this.maxStackSize - this.currentStackSize);
            stack.field_77994_a -= size;
            this.currentStackSize += size;
            if (stack.field_77994_a <= 0) {
                stack = null;
            }
        }
        return stack;
    }

    public boolean canAddStack(ItemStack check) {
        if (check == null) {
            return false;
        }
        if (this.stack == null) {
            return true;
        }
        return this.stack.func_77973_b() == check.func_77973_b() && this.stack.func_77960_j() == check.func_77960_j() && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)check);
    }

    public ItemStack getOutputStack() {
        if (this.stack == null || this.currentStackSize == 0) {
            return null;
        }
        int stackSize = 0;
        int current = (int)Math.floor(this.currentStackSize / this.stack.func_77976_d());
        stackSize = current == this.maxStacks ? this.stack.func_77976_d() : this.currentStackSize - current * this.stack.func_77976_d();
        if (stackSize == 0) {
            return null;
        }
        ItemStack outputStack = this.stack.func_77946_l();
        outputStack.field_77994_a = stackSize;
        if (stackSize == this.stack.func_77976_d()) {
            return null;
        }
        return outputStack;
    }

    public void setItemStack(ItemStack stack) {
        this.stack = stack;
        this.maxStackSize = stack.func_77976_d() * this.maxStacks;
    }

    public ItemStack getFullStack() {
        if (this.stack == null || this.currentStackSize == 0) {
            return null;
        }
        ItemStack full = this.stack.func_77946_l();
        full.field_77994_a = this.currentStackSize;
        return full;
    }

    public ItemStack savedStack() {
        return this.stack;
    }
}

