/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.CalculatorAPI;

public class AtomicMultiplierBlacklist {
    private static final AtomicMultiplierBlacklist blacklist = new AtomicMultiplierBlacklist();
    private Map bannedList = new HashMap();

    public static AtomicMultiplierBlacklist blacklist() {
        return blacklist;
    }

    public AtomicMultiplierBlacklist() {
        String[] blacklisted = CalculatorConfig.atomicblackList.getStringList();
        for (int i = 0; i < blacklisted.length; ++i) {
            String[] parts = blacklisted[i].split(":");
            Item itemBan = GameRegistry.findItem((String)parts[0], (String)parts[1]);
            if (itemBan != null) {
                this.addBan(itemBan);
                continue;
            }
            Block blockBan = GameRegistry.findBlock((String)parts[0], (String)parts[1]);
            if (blockBan == null) continue;
            this.addBan(blockBan);
        }
        List<GameRegistry.UniqueIdentifier> apiBlocked = CalculatorAPI.getItemBlackList();
        for (GameRegistry.UniqueIdentifier item : apiBlocked) {
            if (GameRegistry.findItem((String)item.modId, (String)item.name) != null) {
                this.addBan(GameRegistry.findItem((String)item.modId, (String)item.name));
                continue;
            }
            if (GameRegistry.findBlock((String)item.modId, (String)item.name) == null) continue;
            this.addBan(GameRegistry.findBlock((String)item.modId, (String)item.name));
        }
    }

    public void addBan(Block input) {
        this.addBan(Item.func_150898_a((Block)input));
    }

    public void addBan(Item input) {
        this.bannedList.put(input, false);
    }

    public boolean isAllowed(Item item) {
        Map.Entry entry;
        List<String> apiBlocked = CalculatorAPI.getModBlackList();
        for (String modid : apiBlocked) {
            if (!GameRegistry.findUniqueIdentifierFor((Item)item).modId.equals(modid)) continue;
            return false;
        }
        Iterator iterator = this.bannedList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (item != (Item)(entry = iterator.next()).getKey());
        return (Boolean)entry.getValue();
    }

    private boolean func_151397_a(ItemStack p_151397_1_, ItemStack p_151397_2_) {
        return p_151397_2_.func_77973_b() == p_151397_1_.func_77973_b() && (p_151397_2_.func_77960_j() == Short.MAX_VALUE || p_151397_2_.func_77960_j() == p_151397_1_.func_77960_j());
    }

    public Map getSmeltingList() {
        return this.bannedList;
    }
}

