/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.calculator.mod.common.tileentity.misc.TileEntityFluxController;
import sonar.calculator.mod.utils.FluxNetwork;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketFluxNetworkList
extends PacketCoords {
    public List<FluxNetwork> networks;

    public PacketFluxNetworkList() {
    }

    public PacketFluxNetworkList(int x, int y, int z, List<FluxNetwork> networks) {
        super(x, y, z);
        this.networks = networks;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.networks = new ArrayList<FluxNetwork>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.networks.add(i, FluxNetwork.readFromBuf(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.networks.size());
        for (int i = 0; i < this.networks.size(); ++i) {
            FluxNetwork.writeToBuf(buf, this.networks.get(i));
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketFluxNetworkList> {
        public IMessage processMessage(PacketFluxNetworkList message, TileEntity target) {
            if (target != null && target instanceof TileEntityFlux) {
                TileEntityFlux flux = (TileEntityFlux)target;
                flux.networks = message.networks;
            } else if (target != null && target instanceof TileEntityFluxController) {
                TileEntityFluxController flux = (TileEntityFluxController)target;
                flux.networks = message.networks;
            }
            return null;
        }
    }
}

