/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.nei.handlers;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.CalculatorConfig;
import sonar.core.energy.DischargeValues;
import sonar.core.helpers.FontHelper;

public class CalculatorDischargeHandler
extends TemplateRecipeHandler {
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static ArrayList<DischargePair> ainfo;

    public String getRecipeName() {
        return FontHelper.translate((String)"energy.display");
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(44, 52, 78, 10), "calculatordischarge", new Object[0]));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = DischargeValues.getPowerList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            DischargePair arecipe = new DischargePair(ingredient, (Integer)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.input), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "Calculator:textures/gui/guiCalculatorDischarge.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("calculatordischarge") && ((Object)((Object)this)).getClass() == CalculatorDischargeHandler.class) {
            Map recipes = DischargeValues.getPowerList();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new DischargePair((ItemStack)recipe.getKey(), (Integer)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawExtras(int recipe) {
        ItemStack stack = ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get((int)recipe)).getResult().item;
        int info = DischargeValues.getValueOf((ItemStack)stack);
        int take = info * 78 / CalculatorConfig.getInteger("Standard Machine");
        this.drawProgressBar(44, 26, 176, 0, take, 10, 48, 0);
        fontRenderer.func_78276_b(FontHelper.formatStorage((long)info), 88 - fontRenderer.func_78256_a(" " + info) / 2 - 5, 27, -1);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return "calculatordischarge";
    }

    public class DischargePair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        public int discharge;

        public DischargePair(ItemStack input, int discharge) {
            super((TemplateRecipeHandler)CalculatorDischargeHandler.this);
            this.discharge = discharge;
            input.field_77994_a = 1;
            this.input = new PositionedStack((Object)input, 23, 23);
        }

        public PositionedStack getResult() {
            return this.input;
        }
    }
}

