/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.minetweaker;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.core.helpers.RecipeHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.calculator.scientific")
public class ScientificHandler {
    @ZenMethod
    public static void addRecipe(IIngredient input1, IIngredient input2, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input1, input2, MineTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input1, IIngredient input2) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input1, input2));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private Object input1;
        private Object input2;
        private ItemStack output;

        public RemoveRecipeAction(Object input1, Object input2) {
            if (input1 instanceof IItemStack) {
                input1 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input1));
            }
            if (input1 instanceof IOreDictEntry) {
                input1 = new RecipeHelper.OreStack(((IOreDictEntry)input1).getName(), 1);
            }
            if (input2 instanceof IItemStack) {
                input2 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input2));
            }
            if (input2 instanceof IOreDictEntry) {
                input2 = new RecipeHelper.OreStack(((IOreDictEntry)input2).getName(), 1);
            }
            if (input1 instanceof ILiquidStack || input2 instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a scientific recipe, calculators do not use liquids when crafting, aborting!");
                this.output = null;
                input2 = null;
                input1 = null;
            }
            this.input1 = input1;
            this.input2 = input2;
            ItemStack dummyInput1 = null;
            ItemStack dummyInput2 = null;
            if (input1 instanceof ItemStack) {
                dummyInput1 = (ItemStack)input1;
            }
            if (input1 instanceof RecipeHelper.OreStack) {
                dummyInput1 = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input1).oreString).get(0);
            }
            if (input2 instanceof ItemStack) {
                dummyInput2 = (ItemStack)input2;
            }
            if (input2 instanceof RecipeHelper.OreStack) {
                dummyInput2 = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input2).oreString).get(0);
            }
            this.output = RecipeRegistry.ScientificRecipes.instance().getCraftingResult(new ItemStack[]{dummyInput1, dummyInput2});
        }

        public void apply() {
            if (this.input1 == null || this.input2 == null || this.output == null) {
                return;
            }
            RecipeRegistry.ScientificRecipes.instance().removeRecipe(new Object[]{this.input1, this.input2});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.input1 == null || this.input2 == null || this.output == null) {
                return;
            }
            RecipeRegistry.ScientificRecipes.instance().addRecipe(new Object[]{this.input1, this.input2, this.output});
        }

        public String describe() {
            return String.format("Removing scientific recipe (%s \u00ef\u00bf\u00bd %s = %s)", this.input1, this.input2, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private Object input1;
        private Object input2;
        private ItemStack output;

        public AddRecipeAction(Object input1, Object input2, ItemStack output) {
            if (input1 instanceof IItemStack) {
                input1 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input1));
            }
            if (input1 instanceof IOreDictEntry) {
                input1 = new RecipeHelper.OreStack(((IOreDictEntry)input1).getName(), 1);
            }
            if (input2 instanceof IItemStack) {
                input2 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input2));
            }
            if (input2 instanceof IOreDictEntry) {
                input2 = new RecipeHelper.OreStack(((IOreDictEntry)input2).getName(), 1);
            }
            if (input1 instanceof ILiquidStack || input2 instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a scientific recipe, calculators do not use liquids when crafting, aborting!");
                output = null;
                input2 = null;
                input1 = null;
            }
            this.input1 = input1;
            this.input2 = input2;
            this.output = output;
        }

        public void apply() {
            if (this.input1 == null || this.input2 == null || this.output == null) {
                return;
            }
            RecipeRegistry.ScientificRecipes.instance().addRecipe(new Object[]{this.input1, this.input2, this.output});
        }

        public void undo() {
            if (this.input1 == null || this.input2 == null || this.output == null) {
                return;
            }
            RecipeRegistry.ScientificRecipes.instance().removeRecipe(new Object[]{this.input1, this.input2});
        }

        public String describe() {
            return String.format("Adding scientific recipe (%s \u00ef\u00bf\u00bd %s = %s)", this.input1, this.input2, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

