/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ITeleport;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.utils.TeleporterRegistry;
import sonar.calculator.mod.utils.helpers.TeleporterHelper;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ITextField;

public class TileEntityTeleporter
extends TileEntitySonar
implements ITeleport,
IByteBufTile,
ITextField {
    public int teleporterID;
    public String name = "LINK NAME";
    public String destinationName = "DESTINATION";
    public String password = "";
    public boolean coolDown;
    public boolean passwordMatch;
    public int coolDownTicks = 0;
    public int linkID;
    public String linkPassword = "";
    public List<TeleportLink> links;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.coolDownTicks != 0) {
            --this.coolDownTicks;
        } else if (!this.coolDown) {
            if (this.teleporterID == 0) {
                return;
            }
            this.startTeleportation();
        } else {
            List<EntityPlayer> players = this.getPlayerList();
            if (players == null || players.size() == 0) {
                this.coolDown = false;
            }
        }
    }

    public void startTeleportation() {
        List<ITeleport> links = TeleporterRegistry.getTeleporters();
        if (links != null && links.size() != 1) {
            for (ITeleport teleport : links) {
                TileEntityTeleporter tile = TeleporterRegistry.getTile(teleport);
                if (tile == null) {
                    TeleporterRegistry.removeTeleporter(teleport);
                    return;
                }
                if (tile.teleporterID != 0 && tile.teleporterID == this.linkID) {
                    if (TeleporterHelper.canTeleport(tile, this) && this.canTeleportPlayer() && tile.canTeleportPlayer()) {
                        this.passwordMatch = true;
                        TeleporterHelper.travelToDimension(this.getPlayerList(), tile);
                        this.updateDimensionName(tile.name);
                        continue;
                    }
                    this.passwordMatch = false;
                    continue;
                }
                if (tile.teleporterID != 0) continue;
                tile.resetFrequency();
            }
        } else {
            this.passwordMatch = false;
        }
    }

    public void updateDimensionName(String name) {
        if (!this.destinationName.equals(name)) {
            this.destinationName = name;
            NBTTagCompound syncData = new NBTTagCompound();
            this.writeData(syncData, NBTHelper.SyncType.SYNC);
            SonarCore.network.sendToAllAround((IMessage)new PacketTileSync(this.field_145851_c, this.field_145848_d, this.field_145849_e, syncData), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
        }
    }

    public boolean canTeleportPlayer() {
        boolean flag = true;
        for (int i = 1; i < 3; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (block == Blocks.field_150350_a || block == null) continue;
            flag = false;
        }
        ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
        int stable = 0;
        for (int i = 0; i < dirs.length; ++i) {
            ForgeDirection dir = dirs[i];
            int blocks = 0;
            for (int j = 0; j < 3; ++j) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d - j, this.field_145849_e + dir.offsetZ) != Calculator.stablestoneBlock) continue;
                ++blocks;
            }
            if (blocks != 3) continue;
            blocks = 0;
            ++stable;
        }
        return stable >= 3 && flag && this.field_145848_d - 2 > 0;
    }

    public List<EntityPlayer> getPlayerList() {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e + 1));
        List players = this.field_145850_b.func_82733_a(EntityPlayer.class, aabb, null);
        return players;
    }

    public void resetFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
            this.addToFrequency();
        }
    }

    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.teleporterID == 0) {
                this.teleporterID = TeleporterRegistry.nextID();
            }
            TeleporterRegistry.addTeleporter(this);
        }
    }

    public void removeFromFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            TeleporterRegistry.removeTeleporter(this);
        }
    }

    public void setFrequency(int freq) {
        this.removeFromFrequency();
        this.teleporterID = freq;
        this.addToFrequency();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.teleporterID = nbt.func_74762_e("freq");
            this.linkID = nbt.func_74762_e("linkID");
            this.name = nbt.func_74779_i("name");
            this.destinationName = nbt.func_74779_i("destinationName");
            this.linkPassword = nbt.func_74779_i("linkPassword");
            this.password = nbt.func_74779_i("password");
            this.coolDown = nbt.func_74767_n("coolDown");
            this.passwordMatch = nbt.func_74767_n("passwordMatch");
            this.coolDownTicks = nbt.func_74762_e("coolDownTicks");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("freq", this.teleporterID);
            nbt.func_74768_a("linkID", this.linkID);
            nbt.func_74778_a("name", this.name);
            nbt.func_74778_a("destinationName", this.destinationName);
            nbt.func_74778_a("linkPassword", this.linkPassword);
            nbt.func_74778_a("password", this.password);
            nbt.func_74757_a("coolDown", this.coolDown);
            nbt.func_74757_a("passwordMatch", this.passwordMatch);
            nbt.func_74768_a("coolDownTicks", this.coolDownTicks);
        }
    }

    public void onChunkUnload() {
        this.removeFromFrequency();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            this.addToFrequency();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add("Link Name: " + this.name);
        if (!this.destinationName.equals("DESTINATION")) {
            currenttip.add("Destination: " + this.destinationName);
        }
        return currenttip;
    }

    @Override
    public int teleporterID() {
        return this.teleporterID;
    }

    @Override
    public int xCoord() {
        return this.field_145851_c;
    }

    @Override
    public int yCoord() {
        return this.field_145848_d;
    }

    @Override
    public int zCoord() {
        return this.field_145849_e;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int dimension() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    public void textTyped(String string, int id) {
        if (id == 1) {
            this.name = string;
        }
        if (id == 2) {
            this.password = string;
        }
        if (id == 3) {
            this.linkPassword = string;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            buf.writeInt(this.linkID);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        this.removeFromFrequency();
        if (id == 0) {
            this.linkID = buf.readInt();
        }
        this.addToFrequency();
    }
}

