/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cofh.api.energy.IEnergyProvider;
import ic2.api.energy.tile.IEnergySource;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.api.flux.IFlux;
import sonar.calculator.mod.api.flux.IFluxController;
import sonar.calculator.mod.api.flux.IFluxPlug;
import sonar.calculator.mod.api.flux.IFluxPoint;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.calculator.mod.common.tileentity.TileEntityFluxHandler;
import sonar.calculator.mod.utils.FluxRegistry;
import sonar.calculator.mod.utils.helpers.FluxHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityFluxPlug
extends TileEntityFluxHandler
implements IFluxPlug {
    public int pointCount;
    public int plugCount;
    public int currentInput;
    public int currentOutput;
    public int transfer;
    public long bufferStorage;
    public SyncEnergyStorage buffer = new SyncEnergyStorage(100000);
    public static final int maxTransfer = 2000000000;
    public static final int DISTRIBUTE = 1;
    public static final int SURGE = 2;
    public static final int HYPER_SURGE = 3;
    public static final int GOD_MODE = 4;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isMaster()) {
            return;
        }
        IFluxController controller = FluxHelper.getController(this.networkID());
        List<IFluxPoint> points = FluxHelper.getPoints(this.networkID());
        if (!FluxHelper.checkPlayerName((TileEntity)this, this.networkID())) {
            return;
        }
        this.beginTransfer(controller, points);
    }

    @Override
    public int getBuffer(int export, boolean simulate) {
        export -= this.buffer.extractEnergy(export, simulate);
        return export;
    }

    @Override
    public int pullEnergy(int export, boolean simulate, boolean buffer) {
        if (buffer) {
            export -= this.buffer.extractEnergy(export, simulate);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.handlers[i] == null) continue;
            if (this.handlers[i] instanceof IEnergyProvider) {
                export -= ((IEnergyProvider)this.handlers[i]).extractEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], export, simulate);
                continue;
            }
            if (!(this.handlers[i] instanceof IEnergySource)) continue;
            if (simulate) {
                export = (int)((double)export - ((IEnergySource)this.handlers[i]).getOfferedEnergy() * 4.0);
                continue;
            }
            int remove = (int)Math.min(((IEnergySource)this.handlers[i]).getOfferedEnergy(), (double)(export / 4));
            export -= remove * 4;
            ((IEnergySource)this.handlers[i]).drawEnergy((double)remove);
        }
        return export;
    }

    public void beginTransfer(IFluxController controller, List<IFluxPoint> points) {
        int[] inputList;
        TileEntityFlux.TransferList transferList = FluxHelper.getMaxInput(this.networkID());
        this.currentOutput = FluxHelper.getMaxOutput(this.networkID());
        this.currentInput = transferList.energy;
        this.bufferStorage = FluxHelper.getBuffer(this.networkID());
        int[] currentList = inputList = transferList.inputList;
        int currentTransfer = 0;
        if (controller != null && controller.getTransmitterMode() != 0) {
            TileEntityFlux.TransferList push = this.sendEnergy(controller, currentList, controller.getRecieveMode(), true);
            currentList = push.inputList;
            currentTransfer += push.energy;
        }
        if (points != null && points.size() > 0 && this.currentOutput != 0 && (this.currentInput != 0 || this.bufferStorage != 0L)) {
            for (int i = 0; i < points.size(); ++i) {
                TileEntityFlux.TransferList push;
                TileEntity target = FluxHelper.getTile(points.get(i));
                if (controller == null) {
                    if (target == null || !(target instanceof TileEntityFlux) || ((TileEntityFlux)target).dimension() != this.dimension()) continue;
                    push = this.transferEnergy((IFluxPoint)target, currentList, 0, false);
                    currentList = push.inputList;
                    currentTransfer += push.energy;
                    continue;
                }
                if (!FluxHelper.checkPlayerName(target, this.networkID())) continue;
                push = this.transferEnergy((IFluxPoint)target, currentList, controller.getRecieveMode(), true);
                currentList = push.inputList;
                currentTransfer += push.energy;
            }
        }
        this.transfer = currentTransfer;
    }

    public TileEntityFlux.TransferList sendEnergy(IFluxPoint point, int[] inputList, int recieveMode, boolean allowDimensions) {
        int maxOutput = Math.min(point.maxTransfer(), 2000000000);
        if (maxOutput <= 0) {
            return new TileEntityFlux.TransferList(inputList, 0);
        }
        int outputted = maxOutput - point.pushEnergy(maxOutput, true);
        int[] currentList = inputList;
        int currentTrans = 0;
        List<IFluxPlug> plugs = FluxHelper.getPlugs(this.networkID());
        for (int i = 0; i < plugs.size(); ++i) {
            TileEntity target = FluxHelper.getTile(plugs.get(i));
            if (!(target instanceof IFluxPlug)) continue;
            int plugTransfer = 0;
            int maxTransfer = Math.min(currentList[i], outputted);
            int output = Math.min(maxTransfer - point.pushEnergy(maxTransfer, true), maxTransfer - ((IFluxPlug)target).pullEnergy(maxTransfer, true, true));
            outputted -= (plugTransfer += this.push(point, (IFluxPlug)target, output, false));
            int n = i;
            currentList[n] = currentList[n] - plugTransfer;
            currentTrans += plugTransfer;
        }
        return new TileEntityFlux.TransferList(currentList, currentTrans);
    }

    public TileEntityFlux.TransferList transferEnergy(IFluxPoint point, int[] inputList, int recieveMode, boolean allowDimensions) {
        int maxOutput = Math.min(point.maxTransfer(), 2000000000);
        if (maxOutput <= 0) {
            return new TileEntityFlux.TransferList(inputList, 0);
        }
        int outputted = maxOutput - point.pushEnergy(maxOutput, true);
        int[] currentList = inputList;
        int currentTrans = 0;
        List<IFluxPlug> plugs = FluxHelper.getPlugs(this.networkID());
        for (int i = 0; i < plugs.size(); ++i) {
            int maxTransfer = Math.min(currentList[i], outputted);
            TileEntity target = FluxHelper.getTile(plugs.get(i));
            int plugTransfer = 0;
            if (target == null || !allowDimensions && (!(target instanceof TileEntityFlux) || ((IFluxPlug)target).dimension() != point.dimension()) || !FluxHelper.checkPlayerName(target, this.networkID())) continue;
            switch (recieveMode) {
                case 2: {
                    if (currentList[i] <= 0) break;
                    int limitedOutput = Math.min(currentList[i] - point.pushEnergy(currentList[i], true), currentList[i] - ((IFluxPlug)target).pullEnergy(currentList[i], true, true));
                    plugTransfer += this.push(point, (IFluxPlug)target, limitedOutput, false);
                    break;
                }
                case 3: {
                    int hyperSurge = Math.min(maxOutput - point.pushEnergy(maxOutput, true), maxOutput - ((IFluxPlug)target).pullEnergy(maxOutput, true, true));
                    for (int o = 0; o != 4; ++o) {
                        plugTransfer += this.push(point, (IFluxPlug)target, hyperSurge, false);
                    }
                    break;
                }
                case 4: {
                    int godMode = Math.min(maxOutput - point.pushEnergy(maxOutput, true), maxOutput - ((IFluxPlug)target).pullEnergy(maxOutput, true, true));
                    for (int t = 0; t != 10; ++t) {
                        plugTransfer += this.push(point, (IFluxPlug)target, godMode, false);
                    }
                    break;
                }
                default: {
                    if (recieveMode == 1) {
                        int transfer = 2000000000 - ((IFluxPlug)target).pullEnergy(2000000000, true, true);
                        int percentage = Math.round((float)(maxOutput - point.pushEnergy(maxOutput, true)) / (float)this.currentOutput);
                        int adjustedTransfer = transfer * percentage;
                        maxTransfer = Math.max(10, adjustedTransfer);
                    }
                    int output = Math.min(maxTransfer - point.pushEnergy(maxTransfer, true), maxTransfer - ((IFluxPlug)target).pullEnergy(maxTransfer, true, true));
                    plugTransfer += this.push(point, (IFluxPlug)target, output, false);
                }
            }
            outputted -= plugTransfer;
            int n = i;
            currentList[n] = currentList[n] - plugTransfer;
            currentTrans += plugTransfer;
        }
        return new TileEntityFlux.TransferList(currentList, currentTrans);
    }

    public int beginReceive(IFluxController controller, List<IFluxPoint> points, int receive, boolean simulate) {
        int currentTransfer = 0;
        if (points != null && points.size() > 0 && receive != 0) {
            for (int i = 0; i < points.size(); ++i) {
                TileEntity target = FluxHelper.getTile(points.get(i));
                if (controller == null) {
                    if (target == null || !(target instanceof TileEntityFlux) || ((TileEntityFlux)target).dimension() != this.dimension()) continue;
                    currentTransfer += this.receiveEnergy((IFluxPoint)target, receive, 0, false, simulate);
                    continue;
                }
                if (!FluxHelper.checkPlayerName(target, this.networkID())) continue;
                currentTransfer += this.receiveEnergy((IFluxPoint)target, receive, controller.getRecieveMode(), true, simulate);
            }
        }
        return currentTransfer;
    }

    public int receiveEnergy(IFluxPoint point, int input, int recieveMode, boolean allowDimensions, boolean simulate) {
        int maxOutput = Math.min(point.maxTransfer(), 2000000000);
        if (maxOutput <= 0) {
            return 0;
        }
        int outputted = maxOutput - point.pushEnergy(maxOutput, true);
        int maxTransfer = Math.min(input, outputted);
        int plugTransfer = 0;
        if (allowDimensions || this.dimension() == point.dimension() && FluxHelper.checkPlayerName((TileEntity)this, this.networkID())) {
            switch (recieveMode) {
                case 2: {
                    if (input <= 0) break;
                    int limitedOutput = Math.min(input - point.pushEnergy(input, true), input - this.pullEnergy(input, true));
                    plugTransfer += this.push(point, this, limitedOutput, simulate);
                    break;
                }
                case 3: {
                    int hyperSurge = Math.min(maxOutput - point.pushEnergy(maxOutput, true), maxOutput - this.pullEnergy(maxOutput, true));
                    for (int o = 0; o != 4; ++o) {
                        plugTransfer += this.push(point, this, hyperSurge, simulate);
                    }
                    break;
                }
                case 4: {
                    int godMode = Math.min(maxOutput - point.pushEnergy(maxOutput, true), maxOutput - this.pullEnergy(maxOutput, true));
                    for (int t = 0; t != 10; ++t) {
                        plugTransfer += this.push(point, this, godMode, simulate);
                    }
                    break;
                }
                default: {
                    if (recieveMode == 1) {
                        int transfer = 2000000000 - this.pullEnergy(2000000000, true);
                        int percentage = Math.round((float)(maxOutput - point.pushEnergy(maxOutput, true)) / (float)this.currentOutput);
                        int adjustedTransfer = transfer * percentage;
                        maxTransfer = Math.max(10, adjustedTransfer);
                    }
                    int output = Math.min(maxTransfer - point.pushEnergy(maxTransfer, true), input);
                    plugTransfer += this.push(point, this, output, simulate);
                }
            }
            outputted -= plugTransfer;
        }
        return plugTransfer;
    }

    @Override
    public int receiveEnergy(ForgeDirection dir, int maxTransfer, boolean simulate) {
        int export = maxTransfer;
        TileEntity handler = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)dir);
        if (handler != null) {
            if (handler instanceof IEnergyProvider) {
                export -= ((IEnergyProvider)handler).extractEnergy(dir.getOpposite(), maxTransfer, true);
            } else if (handler instanceof IEnergySource) {
                export = (int)((double)export - ((IEnergySource)handler).getOfferedEnergy() * 4.0);
            }
        }
        if (maxTransfer == export) {
            IFluxPlug plug = (IFluxPlug)FluxRegistry.getMaster(this.networkID());
            TileEntity target = null;
            if (plug != null) {
                target = FluxHelper.getTile(plug);
            }
            if (target != null && !this.networkName.equals("NETWORK")) {
                return this.buffer.receiveEnergy(Math.min(maxTransfer, ((TileEntityFluxPlug)target).currentOutput), simulate);
            }
        }
        return 0;
    }

    public int pushDrainage(TileEntityFluxPlug plug, TileEntityFluxPlug drain, int max, boolean simulate) {
        return max - plug.buffer.receiveEnergy(max - drain.buffer.extractEnergy(max, simulate), simulate);
    }

    public int push(IFluxPoint point, IFluxPlug plug, int max, boolean simulate) {
        return max - point.pushEnergy(max - plug.pullEnergy(max, simulate, true), simulate);
    }

    @Override
    public boolean isMaster() {
        if (FluxRegistry.getMaster(this.networkID()) == null) {
            return false;
        }
        IFlux flux = FluxRegistry.getMaster(this.networkID());
        return flux.networkID() == this.networkID() && flux.dimension() == this.dimension() && flux.xCoord() == this.field_145851_c && flux.yCoord() == this.field_145848_d && flux.zCoord() == this.field_145849_e;
    }

    @Override
    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K && FluxRegistry.getMaster(this.networkID()) == null) {
            FluxRegistry.addMaster(this);
        }
        super.addToFrequency();
    }

    @Override
    public void removeFromFrequency() {
        super.removeFromFrequency();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isMaster()) {
                return;
            }
            FluxRegistry.removeMaster(this);
            List<IFlux> plugs = FluxRegistry.getPlugs(this.networkID());
            boolean masterSet = false;
            if (plugs != null && plugs.size() > 0) {
                for (int i = 0; i < plugs.size(); ++i) {
                    IFlux plug = plugs.get(i);
                    TileEntity target = FluxHelper.getTile(plug);
                    if (target == null || !(target instanceof TileEntityFluxPlug)) continue;
                    TileEntityFluxPlug master = (TileEntityFluxPlug)target;
                    if (!masterSet) {
                        FluxRegistry.addMaster(master);
                        masterSet = true;
                    }
                    this.pushDrainage(master, this, 2000000000, false);
                }
            }
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.transfer = nbt.func_74762_e("transfer");
            this.currentInput = nbt.func_74762_e("currentInput");
            this.currentOutput = nbt.func_74762_e("currentOutput");
            this.buffer.readFromNBT(nbt);
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.plugCount = nbt.func_74762_e("plugCount");
            this.pointCount = nbt.func_74762_e("pointCount");
            this.currentInput = nbt.func_74762_e("currentInput");
            this.currentOutput = nbt.func_74762_e("currentOutput");
            this.bufferStorage = nbt.func_74763_f("bufferStorage");
            this.transfer = nbt.func_74762_e("transfer");
        }
        if (type == NBTHelper.SyncType.DROP) {
            this.buffer.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("transfer", this.transfer);
            nbt.func_74768_a("currentInput", this.currentInput);
            nbt.func_74768_a("currentOutput", this.currentOutput);
            this.buffer.writeToNBT(nbt);
        }
        if (type == NBTHelper.SyncType.SYNC) {
            IFluxPlug plug = (IFluxPlug)FluxRegistry.getMaster(this.networkID());
            TileEntity target = null;
            if (plug != null) {
                target = FluxHelper.getTile(plug);
            }
            nbt.func_74768_a("plugCount", FluxRegistry.plugCount(this.networkID()));
            nbt.func_74768_a("pointCount", FluxRegistry.pointCount(this.networkID()));
            if (target != null && target instanceof TileEntityFluxPlug) {
                nbt.func_74768_a("currentInput", ((TileEntityFluxPlug)target).currentInput);
                nbt.func_74768_a("currentOutput", ((TileEntityFluxPlug)target).currentOutput);
                nbt.func_74768_a("transfer", ((TileEntityFluxPlug)target).transfer);
                nbt.func_74772_a("bufferStorage", ((TileEntityFluxPlug)target).bufferStorage);
            }
        }
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.buffer.getEnergyStored());
        }
    }
}

