/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.tileentity.IEnergyInfo;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.network.packets.PacketCalculatorScreen;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;

public class TileEntityCalculatorScreen
extends TileEntitySonar {
    public int latestMax;
    public int latestEnergy;
    public int lastMax;
    public int lastEnergy;

    public void func_145845_h() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileEntity target = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite());
            if (target == null) {
                return;
            }
            if (target instanceof IEnergyInfo) {
                IEnergyInfo energy = (IEnergyInfo)target;
                int max = energy.getInfoMaxEnergyStored();
                int current = energy.getInfoEnergyStored();
                if (max != this.lastMax) {
                    this.sendMax(max);
                }
                if (current != this.lastEnergy) {
                    this.sendEnergy(current);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (target instanceof IEnergyReceiver) {
                IEnergyReceiver energy = (IEnergyReceiver)target;
                int max = energy.getMaxEnergyStored(ForgeDirection.UNKNOWN);
                int current = energy.getEnergyStored(ForgeDirection.UNKNOWN);
                if (max != this.lastMax) {
                    this.sendMax(max);
                }
                if (current != this.lastEnergy) {
                    this.sendEnergy(current);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (target instanceof IEnergyHandler) {
                IEnergyHandler energy = (IEnergyHandler)target;
                int max = energy.getMaxEnergyStored(ForgeDirection.UNKNOWN);
                int current = energy.getEnergyStored(ForgeDirection.UNKNOWN);
                if (max != this.lastMax) {
                    this.sendMax(max);
                }
                if (current != this.lastEnergy) {
                    this.sendEnergy(current);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public void sendMax(int max) {
        this.func_70296_d();
        this.lastMax = this.latestMax;
        this.latestMax = max;
        if (!this.field_145850_b.field_72995_K) {
            Calculator.network.sendToAllAround((IMessage)new PacketCalculatorScreen(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, max), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
        }
    }

    public void sendEnergy(int energy) {
        this.func_70296_d();
        this.lastEnergy = this.latestEnergy;
        this.latestEnergy = energy;
        if (!this.field_145850_b.field_72995_K) {
            Calculator.network.sendToAllAround((IMessage)new PacketCalculatorScreen(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, energy), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.latestMax = nbt.func_74762_e("latestMax");
            this.latestEnergy = nbt.func_74762_e("latestEnergy");
            this.lastMax = nbt.func_74762_e("lastMax");
            this.lastEnergy = nbt.func_74762_e("lastEnergy");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("latestMax", this.latestMax);
            nbt.func_74768_a("latestEnergy", this.latestEnergy);
            nbt.func_74768_a("lastMax", this.lastMax);
            nbt.func_74768_a("lastEnergy", this.lastEnergy);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

