/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHungerProcessor;
import sonar.calculator.mod.api.nutrition.IHungerStore;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.ISyncTile;

public class TileEntityHungerProcessor
extends TileEntitySidedInventory
implements ISidedInventory,
ISyncTile,
IHungerProcessor {
    public int storedpoints;
    public int speed = 4;

    public TileEntityHungerProcessor() {
        this.input = new int[]{0};
        this.output = new int[]{1};
        this.slots = new ItemStack[2];
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.food(this.slots[0]);
        }
        this.charge(this.slots[1]);
        this.func_70296_d();
    }

    public void charge(ItemStack stack) {
        int max;
        IHungerStore module;
        int hunger;
        if (stack != null && this.storedpoints != 0 && stack.func_77973_b() instanceof IHungerStore && ((hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) < (max = module.getMaxHungerPoints(stack)) || max == -1)) {
            if (this.storedpoints >= this.speed) {
                if (max == -1 || max >= hunger + this.speed) {
                    module.transferHunger(this.speed, stack, ProcessType.ADD);
                    this.storedpoints -= this.speed;
                } else if (max != -1) {
                    module.transferHunger(max - hunger, stack, ProcessType.ADD);
                    this.storedpoints -= max - hunger;
                }
            } else if (this.storedpoints <= this.speed) {
                if (max == -1 | max >= hunger + this.speed) {
                    module.transferHunger(this.speed, stack, ProcessType.ADD);
                    this.storedpoints = 0;
                } else if (max != -1) {
                    module.transferHunger(max - hunger, stack, ProcessType.ADD);
                    this.storedpoints = this.storedpoints - max - hunger;
                }
            }
        }
    }

    private void food(ItemStack stack) {
        if (stack != null) {
            IHungerStore module;
            int hunger;
            if (stack.func_77973_b() instanceof ItemFood) {
                ItemFood food = (ItemFood)stack.func_77973_b();
                this.storedpoints += food.func_150905_g(stack);
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
            }
            if (stack.func_77973_b() instanceof IHungerStore && (hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) != 0) {
                if (hunger >= this.speed) {
                    module.transferHunger(this.speed, stack, ProcessType.REMOVE);
                    this.storedpoints += this.speed;
                } else if (hunger <= this.speed) {
                    module.transferHunger(hunger, stack, ProcessType.REMOVE);
                    this.storedpoints += hunger;
                }
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.storedpoints = nbt.func_74762_e("Food");
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("Food", this.storedpoints);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        if (slot == 1) {
            if (this.storedpoints == 0) {
                return true;
            }
            if (this.storedpoints != 0) {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add(FontHelper.translate((String)"points.hunger") + ": " + this.storedpoints);
        return currenttip;
    }

    @Override
    public int getHungerPoints() {
        return this.storedpoints;
    }
}

