/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.IPausable;
import sonar.calculator.mod.common.item.misc.ItemCircuit;
import sonar.calculator.mod.common.recipes.machines.AlgorithmSeparatorRecipes;
import sonar.core.common.tileentity.TileEntitySidedInventoryReceiver;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RecipeHelper;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.network.sync.SyncTagType;

public class TileEntityFlawlessFurnace
extends TileEntitySidedInventoryReceiver
implements IPausable {
    public SyncTagType.INT[] cookTime = new SyncTagType.INT[9];
    public float renderTicks;
    public double energyBuffer;
    public boolean paused;
    public final int speed = 100;
    public int size = 9;
    public int maxProcess;

    public TileEntityFlawlessFurnace() {
        this.slots = new ItemStack[28];
        this.storage = new SyncEnergyStorage(10000000, 64000);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.paused = true;
            return;
        }
        this.paused = false;
        this.discharge(27);
        if (!this.paused) {
            for (int i = 0; i < 9; ++i) {
                int energyUsage;
                if ((Integer)this.cookTime[i].getObject() > 0) {
                    this.cookTime[i].increaseBy(1);
                    if (!this.field_145850_b.field_72995_K) {
                        this.energyBuffer += this.energyUsage() / 100.0 * 8.0;
                        energyUsage = (int)Math.round(this.energyBuffer);
                        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
                        this.storage.modifyEnergyStored(-energyUsage);
                    }
                }
                if (this.canProcess(i)) {
                    if (this.field_145850_b.field_72995_K) continue;
                    if ((Integer)this.cookTime[i].getObject() == 0) {
                        this.cookTime[i].increaseBy(1);
                        this.energyBuffer += this.energyUsage() / 100.0;
                        energyUsage = (int)Math.round(this.energyBuffer);
                        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
                        this.storage.modifyEnergyStored(-energyUsage);
                    }
                    if ((Integer)this.cookTime[i].getObject() < this.currentSpeed()) continue;
                    for (int process = 0; process < 8; ++process) {
                        if (!this.canProcess(i)) continue;
                        this.finishProcess(i);
                    }
                    if (this.canProcess(i)) {
                        this.cookTime[i].increaseBy(1);
                    }
                    this.cookTime[i].setObject((Object)0);
                    this.energyBuffer = 0.0;
                    continue;
                }
                this.renderTicks = 0.0f;
                if ((Integer)this.cookTime[i].getObject() == 0) continue;
                this.cookTime[i].setObject((Object)0);
                this.energyBuffer = 0.0;
            }
        }
        this.func_70296_d();
    }

    public boolean canProcess(int slot) {
        ItemStack[] output;
        if (this.slots[slot] == null) {
            return false;
        }
        if ((Integer)this.cookTime[slot].getObject() == 0) {
            // empty if block
        }
        if ((output = this.getOutput(true, this.slots[slot])) == null || output.length == 0) {
            return false;
        }
        for (int o = 0; o < output.length; ++o) {
            if (output[o] == null) {
                return false;
            }
            if (this.slots[slot + (o + 1) * 9] == null) continue;
            if (!this.slots[slot + (o + 1) * 9].func_77969_a(output[o])) {
                return false;
            }
            if (this.slots[slot + (o + 1) * 9].field_77994_a + output[o].field_77994_a <= this.slots[slot + (o + 1) * 9].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void finishProcess(int slot) {
        ItemStack[] output = this.getOutput(false, this.slots[slot]);
        for (int o = 0; o < output.length; ++o) {
            if (output[o] == null) continue;
            if (this.slots[slot + (o + 1) * 9] == null) {
                ItemStack outputStack = output[o].func_77946_l();
                if (output[o].func_77973_b() == Calculator.circuitBoard) {
                    ItemCircuit.setData(outputStack);
                }
                this.slots[slot + (o + 1) * 9] = outputStack;
                continue;
            }
            if (!this.slots[slot + (o + 1) * 9].func_77969_a(output[o])) continue;
            this.slots[slot + (o + 1) * 9].field_77994_a += output[o].field_77994_a;
        }
        this.slots[slot].field_77994_a = this.recipeHelper() != null ? (this.slots[slot].field_77994_a -= this.recipeHelper().getInputSize(0, output)) : --this.slots[slot].field_77994_a;
        if (this.slots[slot].field_77994_a <= 0) {
            this.slots[slot] = null;
        }
    }

    public RecipeHelper recipeHelper() {
        return AlgorithmSeparatorRecipes.instance();
    }

    public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
        return this.recipeHelper().getOutput(stacks);
    }

    public int currentSpeed() {
        return 100;
    }

    private int roundNumber(double i) {
        return (int)(Math.ceil(i / 10.0) * 10.0);
    }

    public double energyUsage() {
        return 5000.0;
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            for (int i = 0; i < this.cookTime.length; ++i) {
                this.cookTime[i].readFromNBT(nbt, type);
            }
            this.paused = nbt.func_74767_n("pause");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            for (int i = 0; i < this.cookTime.length; ++i) {
                this.cookTime[i].writeToNBT(nbt, type);
            }
            nbt.func_74757_a("pause", this.paused);
        }
    }

    @Override
    public boolean isActive() {
        return !this.isPaused();
    }

    @Override
    public void onPause() {
        this.paused = !this.paused;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h, 1, 1);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return true;
    }

    public boolean canStack(ItemStack current, ItemStack stack) {
        if (current == null) {
            return true;
        }
        return current.field_77994_a != current.func_77976_d();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        return currenttip;
    }
}

