/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.integration.agricraft.AgriCraftAPIWrapper;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.utils.FailedCoords;

public class TileEntityBasicGreenhouse
extends TileEntityGreenhouse
implements ISidedInventory {
    public int plants;
    public int lanterns;
    public int levelTicks;
    public int checkTicks;
    public int growTicks;
    public int growTick;
    public int stackStairs = 56;
    public int stackLog = 18;
    public int stackPlanks = 30;
    public int stackGlass = 14;
    public int requiredBuildEnergy = (this.stackStairs + this.stackLog + this.stackPlanks + this.stackGlass) * this.buildRF;

    public TileEntityBasicGreenhouse() {
        this.storage = new SyncEnergyStorage(350000, 800);
        this.slots = new ItemStack[14];
        this.type = 1;
        this.maxLevel = 100000;
        this.plantTick = 60;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (!this.isBeingBuilt()) {
            this.checkTile();
        }
        if (this.isCompleted()) {
            if (!this.field_145850_b.field_72995_K) {
                this.extraTicks();
            }
            this.plant();
            this.growTicks();
            this.harvestCrops();
        } else if (this.isBeingBuilt()) {
            this.createMultiblock();
        }
        this.discharge(4);
        this.func_70296_d();
    }

    @Override
    public List<BlockCoords> getPlantArea() {
        ArrayList<BlockCoords> coords = new ArrayList<BlockCoords>();
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        int x = this.field_145851_c + 2 * fX;
        int y = this.field_145848_d;
        int z = this.field_145849_e + 2 * fZ;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                coords.add(new BlockCoords(x + X, y, z + Z));
            }
        }
        return coords;
    }

    public FailedCoords createBlock() {
        FailedCoords coords = this.canMakeMultiblock();
        if (!this.isBeingBuilt() && coords.getBoolean() && this.storage.getEnergyStored() >= this.requiredBuildEnergy && this.hasRequiredStacks()) {
            this.setBeingBuilt();
        }
        return coords;
    }

    public void extraTicks() {
        if (this.levelTicks == 15) {
            this.getPlants();
            this.getLanterns();
        }
        if (this.levelTicks >= 0 && this.levelTicks != 20) {
            ++this.levelTicks;
        }
        if (this.levelTicks == 20) {
            SonarAPI.getItemHelper().transferItems(this.func_145831_w().func_147438_o(this.field_145851_c + this.getForward().getOpposite().offsetX, this.field_145848_d, this.field_145849_e + this.getForward().getOpposite().offsetZ), (TileEntity)this, ForgeDirection.getOrientation((int)0), ForgeDirection.getOrientation((int)0), (InventoryHelper.IInventoryFilter)new TileEntityGreenhouse.PlantableFilter());
            this.levelTicks = 0;
            this.gasLevels();
        }
    }

    private void checkTile() {
        if (this.checkTicks >= 0 && this.checkTicks != 50) {
            ++this.checkTicks;
        }
        if (this.checkTicks == 50) {
            this.checkTicks = 0;
            if (this.isComplete().getBoolean()) {
                if (!this.wasBuilt()) {
                    this.setGas(0);
                    this.setWasBuilt();
                }
                this.setCompleted();
                this.addFarmland();
            } else {
                this.setIncomplete();
            }
        }
    }

    public void growTicks() {
        if (this.growTicks == 0) {
            this.growTick = GreenhouseHelper.getGrowTicks(this.getOxygen(), 1);
            ++this.growTicks;
            return;
        }
        if (this.growTick != 0 && this.growTicks >= this.growTick) {
            if (this.storage.getEnergyStored() >= this.growthRF) {
                if (this.growCrop(1, 0)) {
                    this.storage.modifyEnergyStored(-this.growthRF);
                }
                this.growTicks = 0;
            }
        } else {
            ++this.growTicks;
        }
    }

    public void gasLevels() {
        int add;
        boolean day = this.field_145850_b.func_72935_r();
        if (day) {
            add = this.plants * 8 - this.lanterns * 50;
            this.addGas(-add);
        }
        if (!day) {
            add = this.plants * 2 + this.lanterns * 50;
            this.addGas(add);
        }
    }

    private void getPlants() {
        this.plants = 0;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + X, this.field_145848_d, this.field_145849_e + Z) instanceof IGrowable)) continue;
                ++this.plants;
            }
        }
    }

    private void getLanterns() {
        this.lanterns = 0;
        int x = this.field_145851_c + this.getForward().offsetX * 2;
        int y = this.field_145848_d;
        int z = this.field_145849_e + this.getForward().offsetZ * 2;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                for (int Y = 0; Y <= 3; ++Y) {
                    if (this.field_145850_b.func_147439_a(x + X, y + Y, z + Z) != Calculator.gas_lantern_on) continue;
                    ++this.lanterns;
                }
            }
        }
    }

    public void addGas(int add) {
        if (this.carbonLevels + add < this.maxLevel && this.carbonLevels + add >= 0) {
            this.carbonLevels += add;
        } else {
            if (this.carbonLevels + add > this.maxLevel) {
                this.setGas(this.maxLevel);
            }
            if (this.carbonLevels + add < 0) {
                this.setGas(0);
            }
        }
    }

    public boolean hasRequiredStacks() {
        return this.slots[0] != null && this.slots[1] != null && this.slots[2] != null && this.slots[3] != null && this.slots[0].field_77994_a >= this.stackLog && this.checkLog(Block.func_149634_a((Item)this.slots[0].func_77973_b())) && this.slots[1].field_77994_a >= this.stackStairs && this.checkStairs(Block.func_149634_a((Item)this.slots[1].func_77973_b())) && this.slots[2].field_77994_a >= this.stackGlass && this.checkGlass(Block.func_149634_a((Item)this.slots[2].func_77973_b())) && this.slots[3].field_77994_a >= this.stackPlanks && this.checkPlanks(Block.func_149634_a((Item)this.slots[3].func_77973_b()));
    }

    public FailedCoords canMakeMultiblock() {
        int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
        int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
        int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
        int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        int x = this.field_145851_c + fX * 2;
        int y = this.field_145848_d;
        int z = this.field_145849_e + fZ * 2;
        for (int Z = -3; Z <= 3; ++Z) {
            for (int X = -3; X <= 3; ++X) {
                for (int Y = -1; Y <= 4; ++Y) {
                    if (GreenhouseHelper.r(this.field_145850_b, x + X, y + Y, z + Z) || this.field_145850_b.func_147438_o(x + X, y + Y, z + Z) == this) continue;
                    return new FailedCoords(false, x + X, y + Y, z + Z, FontHelper.translate((String)"locator.none"));
                }
            }
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    private void createMultiblock() {
        int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
        int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
        int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
        int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (this.end(false, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e).getBoolean() && this.start(false, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ).getBoolean() && this.sides(false, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e).getBoolean() && this.roof(false, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e).getBoolean() && this.underroof(false, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e).getBoolean()) {
            this.addFarmland();
            this.isMulti = 1;
        }
    }

    public FailedCoords isComplete() {
        if (RenderHelper.getHorizontal((ForgeDirection)this.getForward()) != null) {
            int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
            int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
            int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
            int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
            int fX = this.getForward().offsetX;
            int fZ = this.getForward().offsetZ;
            int x = this.field_145851_c;
            int y = this.field_145848_d;
            int z = this.field_145849_e;
            FailedCoords end = this.end(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            FailedCoords start = this.start(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ);
            FailedCoords sides = this.sides(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            FailedCoords roof = this.roof(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            FailedCoords underroof = this.underroof(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!end.getBoolean()) {
                return end;
            }
            if (!start.getBoolean()) {
                return start;
            }
            if (!sides.getBoolean()) {
                return sides;
            }
            if (!roof.getBoolean()) {
                return roof;
            }
            if (!underroof.getBoolean()) {
                return underroof;
            }
            return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
        }
        return new FailedCoords(false, 0, 0, 0, "Something went wrong...");
    }

    private void addFarmland() {
        ForgeDirection forward = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        int x = this.field_145851_c + 2 * forward.offsetX;
        int y = this.field_145848_d;
        int z = this.field_145849_e + 2 * forward.offsetZ;
        for (int Z = -1; Z <= 1; ++Z) {
            for (int X = -1; X <= 1; ++X) {
                if (X == 0 && Z == 0) {
                    if (this.storage.getEnergyStored() < this.waterRF || !GreenhouseHelper.applyWater(this.field_145850_b, x + X, y, z + Z)) continue;
                    this.storage.modifyEnergyStored(-this.waterRF);
                    continue;
                }
                if (this.storage.getEnergyStored() >= this.farmlandRF && GreenhouseHelper.applyFarmland(this.field_145850_b, x + X, y, z + Z)) {
                    this.storage.modifyEnergyStored(-this.farmlandRF);
                }
                AgriCraftAPIWrapper.getInstance().removeWeeds(this.field_145850_b, x + X, y, z + Z, false);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isMulti = nbt.func_74762_e("Multi");
        this.planting = nbt.func_74762_e("planting");
        this.plants = nbt.func_74762_e("Plants");
        this.lanterns = nbt.func_74762_e("lanterns");
        this.carbonLevels = nbt.func_74762_e("Carbon");
        this.levelTicks = nbt.func_74762_e("Level");
        this.plantTicks = nbt.func_74762_e("Plant");
        this.checkTicks = nbt.func_74762_e("Check");
        this.growTicks = nbt.func_74762_e("Grow");
        this.growTick = nbt.func_74762_e("GrowTick");
        this.wasBuilt = nbt.func_74762_e("wasBuilt");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        nbt.func_74768_a("Multi", this.isMulti);
        nbt.func_74768_a("planting", this.planting);
        nbt.func_74768_a("Plants", this.plants);
        nbt.func_74768_a("lanterns", this.lanterns);
        nbt.func_74768_a("Carbon", this.carbonLevels);
        nbt.func_74768_a("Level", this.levelTicks);
        nbt.func_74768_a("Check", this.checkTicks);
        nbt.func_74768_a("Plant", this.plantTicks);
        nbt.func_74768_a("Grow", this.growTicks);
        nbt.func_74768_a("GrowTick", this.growTick);
        nbt.func_74768_a("wasBuilt", this.wasBuilt);
    }

    public void setLog(int x, int y, int z) {
        if (this.slots[0] == null) {
            this.setIncomplete();
        }
        if (this.slots[0] != null) {
            Block log = Block.func_149634_a((Item)this.slots[0].func_77973_b());
            int damage = this.slots[0].func_77960_j();
            if (!this.checkLog(log)) {
                this.setIncomplete();
            } else if (log != null) {
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a == 1) {
                    this.slots[0] = null;
                }
                this.field_145850_b.func_147465_d(x, y, z, log, damage, 2);
                this.storage.modifyEnergyStored(-this.buildRF);
            }
        }
    }

    public void setGlass(int x, int y, int z) {
        if (this.slots[2] == null) {
            this.setIncomplete();
        }
        if (this.slots[2] != null) {
            Block glass = Block.func_149634_a((Item)this.slots[2].func_77973_b());
            int damage = this.slots[2].func_77960_j();
            if (!this.checkGlass(glass)) {
                this.setIncomplete();
            } else if (glass != null) {
                --this.slots[2].field_77994_a;
                if (this.slots[2].field_77994_a == 1) {
                    this.slots[2] = null;
                }
                this.field_145850_b.func_147465_d(x, y, z, glass, damage, 2);
                this.storage.modifyEnergyStored(-this.buildRF);
            }
        }
    }

    public void setPlanks(int x, int y, int z) {
        if (this.slots[3] == null) {
            this.setIncomplete();
        }
        if (this.slots[3] != null) {
            Block planks = Block.func_149634_a((Item)this.slots[3].func_77973_b());
            int damage = this.slots[3].func_77960_j();
            if (!this.checkPlanks(planks)) {
                this.setIncomplete();
            } else if (planks != null) {
                --this.slots[3].field_77994_a;
                if (this.slots[3].field_77994_a == 1) {
                    this.slots[3] = null;
                }
                this.field_145850_b.func_147465_d(x, y, z, planks, damage, 2);
                this.storage.modifyEnergyStored(-this.buildRF);
            }
        }
    }

    public void setStairs(int x, int y, int z, int meta, int flag) {
        if (this.slots[1] == null) {
            this.setIncomplete();
        }
        if (this.slots[1] != null) {
            Block stairs = Block.func_149634_a((Item)this.slots[1].func_77973_b());
            if (!this.checkStairs(stairs)) {
                this.setIncomplete();
            } else if (stairs != null) {
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 1) {
                    this.slots[1] = null;
                }
                this.field_145850_b.func_147465_d(x, y, z, stairs, meta, flag);
                this.storage.modifyEnergyStored(-this.buildRF);
            }
        }
    }

    public FailedCoords roof(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = -1; i <= 1; ++i) {
            if (this.getPlanks(w.func_147439_a(x + hX * i, y + 3, z + hZ * i))) {
                if (!check) {
                    this.setPlanks(x + hX * i, y + 3, z + hZ * i);
                }
                return new FailedCoords(false, x + hX * i, y + 3, z + hZ * i, FontHelper.translate((String)"greenhouse.planks"));
            }
            if (!this.getPlanks(w.func_147439_a(x + hX * i + fX * 4, y + 3, z + hZ * i + fZ * 4))) continue;
            if (!check) {
                this.setPlanks(x + hX * i + fX * 4, y + 3, z + hZ * i + fZ * 4);
            }
            return new FailedCoords(false, x + hX * i + fX * 4, y + 3, z + hZ * i + fZ * 4, FontHelper.translate((String)"greenhouse.planks"));
        }
        for (i = -1; i <= 5; ++i) {
            for (int s = 2; s <= 4; ++s) {
                if (this.getStairs(w.func_147439_a(x + hX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i))) {
                    if (!check) {
                        this.setStairs(x + hX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i, this.type("r"), 2);
                    }
                    return new FailedCoords(false, x + hX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
                }
                if (this.getStairs(w.func_147439_a(x + hoX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hoZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i))) {
                    if (!check) {
                        this.setStairs(x + hoX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hoZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i, this.type("l"), 2);
                    }
                    return new FailedCoords(false, x + hoX * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fX * i, y + s, z + hoZ * this.intValues(s, FontHelper.translate((String)"greenhouse.stairs")) + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
                }
                if (!this.getPlanks(w.func_147439_a(x + fX * i, y + 4, this.field_145849_e + fZ * i))) continue;
                if (!check) {
                    this.setPlanks(x + fX * i, y + 4, this.field_145849_e + fZ * i);
                }
                return new FailedCoords(false, x + fX * i, y + 4, this.field_145849_e + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
            }
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords underroof(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        for (int i = -1; i <= 5; ++i) {
            if (i != -1 && i != 0 && i != 4 && i != 5) {
                if (this.getStairs(w.func_147439_a(x + hX + fX * i, y + 3, z + hZ + fZ * i))) {
                    if (!check) {
                        this.setStairs(x + hX + fX * i, y + 3, z + hZ + fZ * i, this.type("d"), 2);
                    }
                    return new FailedCoords(false, x + hX + fX * i, y + 3, z + hZ + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
                }
                if (!this.getStairs(w.func_147439_a(x + hoX + fX * i, y + 3, z + hoZ + fZ * i))) continue;
                if (!check) {
                    this.setStairs(x + hoX + fX * i, y + 3, z + hoZ + fZ * i, this.type("d2"), 2);
                }
                return new FailedCoords(false, x + hoX + fX * i, y + 3, z + hoZ + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
            }
            if (i == 0 || i == 4) continue;
            if (this.getStairs(w.func_147439_a(x + hX + fX * i, y + 3, z + hZ + fZ * i))) {
                if (!check) {
                    this.setStairs(x + hX + fX * i, y + 3, z + hZ + fZ * i, this.type("d"), 2);
                }
                return new FailedCoords(false, x + hX + fX * i, y + 3, z + hZ + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
            }
            if (this.getStairs(w.func_147439_a(x + hoX + fX * i, y + 3, z + hoZ + fZ * i))) {
                if (!check) {
                    this.setStairs(x + hoX + fX * i, y + 3, z + hoZ + fZ * i, this.type("d2"), 2);
                }
                return new FailedCoords(false, x + hoX + fX * i, y + 3, z + hoZ + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
            }
            if (i == 0 || i == 4) continue;
            if (this.getStairs(w.func_147439_a(x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i))) {
                if (!check) {
                    this.setStairs(x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i, this.type("d"), 2);
                }
                return new FailedCoords(false, x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
            }
            if (!this.getStairs(w.func_147439_a(x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i))) continue;
            if (!check) {
                this.setStairs(x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i, this.type("d2"), 2);
            }
            return new FailedCoords(false, x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.stairs"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords sides(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        for (int i = 1; i <= 3; ++i) {
            if (i != 2) {
                if (this.getPlanks(w.func_147439_a(x + hX * 2 + fX * i, y - 1, z + hZ * 2 + fZ * i))) {
                    if (!check) {
                        this.setPlanks(x + hX * 2 + fX * i, y - 1, z + hZ * 2 + fZ * i);
                    }
                    return new FailedCoords(false, x + hX * 2 + fX * i, y - 1, z + hZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.planks"));
                }
                if (this.getPlanks(w.func_147439_a(x + hoX * 2 + fX * i, y - 1, z + hoZ * 2 + fZ * i))) {
                    if (!check) {
                        this.setPlanks(x + hoX * 2 + fX * i, y - 1, z + hoZ * 2 + fZ * i);
                    }
                    return new FailedCoords(false, x + hoX * 2 + fX * i, y - 1, z + hoZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.planks"));
                }
                for (int s = 0; s <= 1; ++s) {
                    if (this.getGlass(w.func_147439_a(x + hX * 2 + fX * i, y + s, z + hZ * 2 + fZ * i))) {
                        if (!check) {
                            this.setGlass(x + hX * 2 + fX * i, y + s, z + hZ * 2 + fZ * i);
                        }
                        return new FailedCoords(false, x + hX * 2 + fX * i, y + s, z + hZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.glass"));
                    }
                    if (!this.getGlass(w.func_147439_a(x + hoX * 2 + fX * i, y + s, z + hoZ * 2 + fZ * i))) continue;
                    if (!check) {
                        this.setGlass(x + hoX * 2 + fX * i, y + s, z + hoZ * 2 + fZ * i);
                    }
                    return new FailedCoords(false, x + hoX * 2 + fX * i, y + s, z + hoZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.glass"));
                }
            }
            if (this.getPlanks(w.func_147439_a(x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i))) {
                if (!check) {
                    this.setPlanks(x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i);
                }
                return new FailedCoords(false, x + hX * 2 + fX * i, y + 2, z + hZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.planks"));
            }
            if (!this.getPlanks(w.func_147439_a(x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i))) continue;
            if (!check) {
                this.setPlanks(x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i);
            }
            return new FailedCoords(false, x + hoX * 2 + fX * i, y + 2, z + hoZ * 2 + fZ * i, FontHelper.translate((String)"greenhouse.planks"));
        }
        for (int Y = 0; Y <= 1; ++Y) {
            if (this.getLog(w.func_147439_a(x + hX * 2 + fX * 2, y + Y, z + hZ * 2 + fZ * 2))) {
                if (!check) {
                    this.setLog(x + hX * 2 + fX * 2, y + Y, z + hZ * 2 + fZ * 2);
                }
                return new FailedCoords(false, x + hX * 2 + fX * 2, y + Y, z + hZ * 2 + fZ * 2, FontHelper.translate((String)"greenhouse.logs"));
            }
            if (!this.getLog(w.func_147439_a(x + hoX * 2 + fX * 2, y + Y, z + hoZ * 2 + fZ * 2))) continue;
            if (!check) {
                this.setLog(x + hoX * 2 + fX * 2, y + Y, z + hoZ * 2 + fZ * 2);
            }
            return new FailedCoords(false, x + hoX * 2 + fX * 2, y + Y, z + hoZ * 2 + fZ * 2, FontHelper.translate((String)"greenhouse.logs"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords end(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = 1; i <= 2; ++i) {
            if (!this.getLog(w.func_147439_a(x, y + i, z))) continue;
            if (!check) {
                this.setLog(x, y + i, z);
            }
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.logs"));
        }
        for (i = 0; i <= 2; ++i) {
            if (this.getLog(w.func_147439_a(x + hX * 2, y + i, z + hZ * 2))) {
                if (!check) {
                    this.setLog(x + hX * 2, y + i, z + hZ * 2);
                }
                return new FailedCoords(false, x + hX * 2, y + i, z + hZ * 2, FontHelper.translate((String)"greenhouse.logs"));
            }
            if (!this.getLog(w.func_147439_a(x + hoX * 2, y + i, z + hoZ * 2))) continue;
            if (!check) {
                this.setLog(x + hoX * 2, y + i, z + hoZ * 2);
            }
            return new FailedCoords(false, x + hoX * 2, y + i, z + hoZ * 2, FontHelper.translate((String)"greenhouse.logs"));
        }
        for (i = 0; i <= 2; ++i) {
            if (this.getGlass(w.func_147439_a(x + hX, y + i, z + hZ))) {
                if (!check) {
                    this.setGlass(x + hX, y + i, z + hZ);
                }
                return new FailedCoords(false, x + hX, y + i, z + hZ, FontHelper.translate((String)"greenhouse.glass"));
            }
            if (!this.getGlass(w.func_147439_a(x + hoX, y + i, z + hoZ))) continue;
            if (!check) {
                this.setGlass(x + hoX, y + i, z + hoZ);
            }
            return new FailedCoords(false, x + hoX, y + i, z + hoZ, FontHelper.translate((String)"greenhouse.glass"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords start(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ) {
        int i;
        int x = this.field_145851_c + this.getForward().offsetX * 4;
        int y = this.field_145848_d;
        int z = this.field_145849_e + this.getForward().offsetZ * 4;
        for (i = 0; i <= 2; ++i) {
            if (this.getLog(w.func_147439_a(x + hX * 2, y + i, z + hZ * 2))) {
                if (!check) {
                    this.setLog(x + hX * 2, y + i, z + hZ * 2);
                }
                return new FailedCoords(false, x + hX * 2, y + i, z + hZ * 2, FontHelper.translate((String)"greenhouse.logs"));
            }
            if (!this.getLog(w.func_147439_a(x + hoX * 2, y + i, z + hoZ * 2))) continue;
            if (!check) {
                this.setLog(x + hoX * 2, y + i, z + hoZ * 2);
            }
            return new FailedCoords(false, x + hoX * 2, y + i, z + hoZ * 2, FontHelper.translate((String)"greenhouse.logs"));
        }
        for (i = 0; i <= 2; ++i) {
            if (this.getPlanks(w.func_147439_a(x + hX * 1, y + i, z + hZ * 1))) {
                if (!check) {
                    this.setPlanks(x + hX * 1, y + i, z + hZ * 1);
                }
                return new FailedCoords(false, x + hX * 1, y + i, z + hZ * 1, FontHelper.translate((String)"greenhouse.planks"));
            }
            if (this.getPlanks(w.func_147439_a(x + hoX * 1, y + i, z + hoZ * 1))) {
                if (!check) {
                    this.setPlanks(x + hoX * 1, y + i, z + hoZ * 1);
                }
                return new FailedCoords(false, x + hoX * 1, y + i, z + hoZ * 1, FontHelper.translate((String)"greenhouse.planks"));
            }
            if (i != 2 || !this.getPlanks(w.func_147439_a(x, y + i, z))) continue;
            if (!check) {
                this.setPlanks(x, y + i, z);
            }
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.planks"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public String getRequiredStacks() {
        if (this.slots[0] == null) {
            return FontHelper.translate((String)"greenhouse.logStack") + " " + FontHelper.translate((String)"greenhouse.isEmpty");
        }
        if (this.slots[1] == null) {
            return FontHelper.translate((String)"greenhouse.stairsStack") + " " + FontHelper.translate((String)"greenhouse.isEmpty");
        }
        if (this.slots[2] == null) {
            return FontHelper.translate((String)"greenhouse.glassStack") + " " + FontHelper.translate((String)"greenhouse.isEmpty");
        }
        if (this.slots[3] == null) {
            return FontHelper.translate((String)"greenhouse.plankStack") + " " + FontHelper.translate((String)"greenhouse.isEmpty");
        }
        if (this.slots[0] != null && this.slots[1] != null && this.slots[2] != null && this.slots[3] != null) {
            if (!this.checkLog(Block.func_149634_a((Item)this.slots[0].func_77973_b()))) {
                return FontHelper.translate((String)"greenhouse.logStack") + " " + FontHelper.translate((String)"greenhouse.noLogs");
            }
            if (!this.checkStairs(Block.func_149634_a((Item)this.slots[1].func_77973_b()))) {
                return FontHelper.translate((String)"greenhouse.stairsStack") + " " + FontHelper.translate((String)"greenhouse.noStairs");
            }
            if (!this.checkGlass(Block.func_149634_a((Item)this.slots[2].func_77973_b()))) {
                return FontHelper.translate((String)"greenhouse.glassStack") + " " + FontHelper.translate((String)"greenhouse.noGlass");
            }
            if (!this.checkPlanks(Block.func_149634_a((Item)this.slots[3].func_77973_b()))) {
                return FontHelper.translate((String)"greenhouse.plankStack") + " " + FontHelper.translate((String)"greenhouse.noPlanks");
            }
            if (this.slots[0].field_77994_a < this.stackLog) {
                String logs = FontHelper.translate((String)"greenhouse.requires") + " " + (this.stackLog - this.slots[0].field_77994_a) + " " + FontHelper.translate((String)"greenhouse.moreLogs");
                return logs;
            }
            if (this.slots[1].field_77994_a < this.stackStairs) {
                String stairs = FontHelper.translate((String)"greenhouse.requires") + " " + (this.stackStairs - this.slots[1].field_77994_a) + " " + FontHelper.translate((String)"greenhouse.moreStairs");
                return stairs;
            }
            if (this.slots[2].field_77994_a < this.stackGlass) {
                String stairs = FontHelper.translate((String)"greenhouse.requires") + " " + (this.stackGlass - this.slots[2].field_77994_a) + " " + FontHelper.translate((String)"greenhouse.moreGlass");
                return stairs;
            }
            if (this.slots[3].field_77994_a < this.stackPlanks) {
                String stairs = FontHelper.translate((String)"greenhouse.requires") + " " + (this.stackPlanks - this.slots[3].field_77994_a) + " " + FontHelper.translate((String)"greenhouse.morePlanks");
                return stairs;
            }
        }
        return FontHelper.translate((String)"locator.unknown");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        switch (this.isMulti) {
            case -1: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.building"));
                break;
            }
            case 0: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.incomplete"));
                break;
            }
            case 1: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.complete"));
                break;
            }
            case 2: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.complete"));
            }
        }
        return super.getWailaInfo(currenttip);
    }

    public int[] func_94128_d(int side) {
        return new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return item != null && item.func_77973_b() instanceof IPlantable;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }
}

