/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.api.nutrition.IHungerStore;
import sonar.calculator.mod.common.block.CalculatorLeaves;
import sonar.calculator.mod.common.block.CalculatorLogs;
import sonar.calculator.mod.integration.planting.TreeHarvestRecipes;
import sonar.core.api.ActionType;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;

public abstract class TileEntityAssimilator
extends TileEntityInventory {
    public boolean hasTree;
    public Random rand = new Random();
    public int tickRate = 30;
    public int tick;

    public abstract boolean harvestBlock(BlockCoords var1);

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick != this.tickRate) {
            ++this.tick;
        } else {
            List<BlockCoords> leaves;
            if (this instanceof Algorithm) {
                ForgeDirection dir = SonarHelper.getForward((int)this.func_145832_p());
                SonarAPI.getItemHelper().transferItems((TileEntity)this, this.func_145831_w().func_147438_o(this.field_145851_c + dir.getOpposite().offsetX, this.field_145848_d, this.field_145849_e + dir.getOpposite().offsetZ), dir, dir.getOpposite(), null);
            }
            this.tick = 0;
            this.hasTree = this.hasTree();
            if (this.hasTree && (leaves = this.getLeaves()) != null && leaves.size() != 0) {
                for (BlockCoords coords : leaves) {
                    Block block = coords.getBlock(this.field_145850_b);
                    int meta = this.field_145850_b.func_72805_g(coords.getX(), coords.getY(), coords.getZ());
                    if (meta <= 2 || !this.harvestBlock(coords)) continue;
                    return;
                }
            }
        }
    }

    public boolean hasTree() {
        ForgeDirection dir = SonarHelper.getForward((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        boolean flag = true;
        for (int log = 0; log < 3; ++log) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + log, this.field_145849_e + dir.offsetZ) instanceof CalculatorLogs) continue;
            flag = false;
        }
        int leafCount = 0;
        for (int X = -3; X < 3; ++X) {
            for (int Z = -3; Z < 3; ++Z) {
                for (int leaves = 1; leaves < 8; ++leaves) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX + X, this.field_145848_d + leaves, this.field_145849_e + dir.offsetZ + Z) instanceof CalculatorLeaves) continue;
                    ++leafCount;
                }
            }
        }
        if (leafCount < 10) {
            flag = false;
        }
        return flag;
    }

    public List<BlockCoords> getLeaves() {
        ForgeDirection dir = SonarHelper.getForward((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        ArrayList<BlockCoords> leafList = new ArrayList<BlockCoords>();
        for (int X = -2; X < 3; ++X) {
            for (int Z = -2; Z < 3; ++Z) {
                for (int leaves = 1; leaves < 8; ++leaves) {
                    if (!(this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX + X, this.field_145848_d + leaves, this.field_145849_e + dir.offsetZ + Z) instanceof CalculatorLeaves)) continue;
                    leafList.add(new BlockCoords(this.field_145851_c + dir.offsetX + X, this.field_145848_d + leaves, this.field_145849_e + dir.offsetZ + Z));
                }
            }
        }
        return leafList;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.tick = nbt.func_74762_e("tick");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("tick", this.tick);
        }
    }

    public static class Algorithm
    extends TileEntityAssimilator
    implements ISidedInventory {
        public Algorithm() {
            this.slots = new ItemStack[27];
        }

        @Override
        public boolean harvestBlock(BlockCoords block) {
            int meta = this.field_145850_b.func_72805_g(block.getX(), block.getY(), block.getZ());
            if (meta > 2) {
                int randInt = 3 + this.rand.nextInt(3);
                ItemStack[] stacks = TreeHarvestRecipes.harvestLeaves(this.field_145850_b, block.getX(), block.getY(), block.getZ(), randInt);
                ForgeDirection forward = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                for (ItemStack s : stacks) {
                    if (s == null) continue;
                    ItemStack stack = s.func_77946_l();
                    TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + forward.getOpposite().offsetX, this.field_145848_d, this.field_145849_e + forward.getOpposite().offsetZ);
                    StoredItemStack storedstack = new StoredItemStack(stack);
                    StoredItemStack harvest = SonarAPI.getItemHelper().addItems((TileEntity)this, storedstack.copy(), ForgeDirection.getOrientation((int)0), ActionType.PERFORM, null);
                    storedstack.remove(harvest);
                    if (storedstack == null || storedstack.stored <= 0L) continue;
                    EntityItem drop = new EntityItem(this.field_145850_b, (double)(this.field_145851_c + forward.getOpposite().offsetX), (double)this.field_145848_d, (double)(this.field_145849_e + forward.getOpposite().offsetZ), storedstack.getFullStack());
                    this.field_145850_b.func_72838_d((Entity)drop);
                }
                return true;
            }
            return false;
        }

        public int[] func_94128_d(int side) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
        }

        public boolean func_102007_a(int slot, ItemStack item, int side) {
            return true;
        }

        public boolean func_102008_b(int slot, ItemStack item, int side) {
            return true;
        }
    }

    public static class Stone
    extends TileEntityAssimilator {
        public int healthPoints;
        public int hungerPoints;
        public int speed = 4;

        public Stone() {
            this.slots = new ItemStack[1];
        }

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.chargeHunger(this.slots[0]);
            this.chargeHealth(this.slots[0]);
        }

        @Override
        public boolean harvestBlock(BlockCoords block) {
            if (block.getBlock(this.field_145850_b) == Calculator.tanzaniteLeaf) {
                ++this.healthPoints;
                this.field_145850_b.func_72921_c(block.getX(), block.getY(), block.getZ(), 0, 2);
                return true;
            }
            if (block.getBlock(this.field_145850_b) == Calculator.amethystLeaf) {
                ++this.hungerPoints;
                this.field_145850_b.func_72921_c(block.getX(), block.getY(), block.getZ(), 0, 2);
                return true;
            }
            return false;
        }

        public void chargeHunger(ItemStack stack) {
            int max;
            IHungerStore module;
            int hunger;
            if (stack != null && this.hungerPoints != 0 && stack.func_77973_b() instanceof IHungerStore && ((hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) < (max = module.getMaxHungerPoints(stack)) || max == -1)) {
                if (this.hungerPoints >= this.speed) {
                    if (max == -1 || max >= hunger + this.speed) {
                        module.transferHunger(this.speed, stack, ProcessType.ADD);
                        this.hungerPoints -= this.speed;
                    } else if (max != -1) {
                        module.transferHunger(max - hunger, stack, ProcessType.ADD);
                        this.hungerPoints -= max - hunger;
                    }
                } else if (this.hungerPoints <= this.speed) {
                    if (max == -1 | max >= hunger + this.speed) {
                        module.transferHunger(this.speed, stack, ProcessType.ADD);
                        this.hungerPoints = 0;
                    } else if (max != -1) {
                        module.transferHunger(max - hunger, stack, ProcessType.ADD);
                        this.hungerPoints = this.hungerPoints - max - hunger;
                    }
                }
            }
        }

        public void chargeHealth(ItemStack stack) {
            int max;
            IHealthStore module;
            int health;
            if (stack != null && this.healthPoints != 0 && stack.func_77973_b() instanceof IHealthStore && ((health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) < (max = module.getMaxHealthPoints(stack)) || max == -1)) {
                if (this.healthPoints >= this.speed) {
                    if (max == -1 || max >= health + this.speed) {
                        module.transferHealth(this.speed, stack, ProcessType.ADD);
                        this.healthPoints -= this.speed;
                    } else if (max != -1) {
                        module.transferHealth(max - health, stack, ProcessType.ADD);
                        this.healthPoints -= max - health;
                    }
                } else if (this.healthPoints <= this.speed) {
                    if (max == -1 | max >= health + this.speed) {
                        module.transferHealth(this.speed, stack, ProcessType.ADD);
                        this.healthPoints = 0;
                    } else if (max != -1) {
                        module.transferHealth(max - health, stack, ProcessType.ADD);
                        this.healthPoints = this.healthPoints - max - health;
                    }
                }
            }
        }

        @Override
        public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            super.readData(nbt, type);
            this.healthPoints = nbt.func_74762_e("health");
            this.hungerPoints = nbt.func_74762_e("hunger");
            if (type != NBTHelper.SyncType.DROP) {
                this.hasTree = nbt.func_74767_n("hasTree");
            }
        }

        @Override
        public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            super.writeData(nbt, type);
            nbt.func_74768_a("health", this.healthPoints);
            nbt.func_74768_a("hunger", this.hungerPoints);
            if (type != NBTHelper.SyncType.DROP) {
                nbt.func_74757_a("hasTree", this.hasTree);
            }
        }
    }
}

