/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.common.recipes.machines.AnalysingChamberRecipes;
import sonar.core.api.IUpgradeCircuits;
import sonar.core.common.tileentity.TileEntitySidedInventorySender;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityAnalysingChamber
extends TileEntitySidedInventorySender
implements ISidedInventory,
IUpgradeCircuits,
IAdditionalInventory {
    public int stable;
    public int vUpgrade;
    public int analysed;
    public int maxTransfer = 2000;

    public TileEntityAnalysingChamber() {
        this.input = new int[]{0};
        this.output = new int[]{2, 3, 4, 5, 6, 7};
        this.storage = new SyncEnergyStorage(1000000, 64000);
        this.slots = new ItemStack[8];
        ((TileEntitySidedInventorySender)this).maxTransfer = 2000;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.analysed == 1 && this.slots[0] == null) {
            this.analysed = 0;
            this.stable = 0;
        }
        if (this.canAnalyse()) {
            this.analyse(0);
        }
        this.charge(1);
        this.addEnergy();
        this.stable = this.stable(0);
        this.func_70296_d();
    }

    private void addEnergy() {
        TileEntity entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (SonarHelper.isEnergyHandlerFromSide((TileEntity)entity, (ForgeDirection)ForgeDirection.DOWN) && entity instanceof IEnergyHandler) {
            this.storage.modifyEnergyStored(-((IEnergyHandler)entity).receiveEnergy(ForgeDirection.UP, this.storage.extractEnergy(this.maxTransfer, true), false));
        }
    }

    private void analyse(int slot) {
        if (this.slots[slot].func_77942_o()) {
            NBTTagCompound tag = this.slots[slot].func_77978_p();
            int storedEnergy = TileEntityAnalysingChamber.itemEnergy(this.slots[slot].func_77978_p().func_74762_e("Energy"));
            this.storage.receiveEnergy(storedEnergy, false);
            if (this.vUpgrade == 0) {
                ItemStack item1 = AnalysingChamberRecipes.instance().getResult(1, tag.func_74762_e("Item1"));
                ItemStack item2 = AnalysingChamberRecipes.instance().getResult(1, tag.func_74762_e("Item2"));
                if (item1 != null) {
                    this.add(item1, 2);
                }
                if (item2 == null) {
                    this.add(item2, 3);
                }
            }
            ItemStack item3 = AnalysingChamberRecipes.instance().getResult(2, tag.func_74762_e("Item3"));
            ItemStack item4 = AnalysingChamberRecipes.instance().getResult(3, tag.func_74762_e("Item4"));
            ItemStack item5 = AnalysingChamberRecipes.instance().getResult(4, tag.func_74762_e("Item5"));
            ItemStack item6 = AnalysingChamberRecipes.instance().getResult(5, tag.func_74762_e("Item6"));
            if (item3 != null) {
                this.add(item3, 4);
            }
            if (item4 != null) {
                this.add(item4, 5);
            }
            if (item5 != null) {
                this.add(item5, 6);
            }
            if (item6 != null) {
                this.add(item6, 7);
            }
            tag.func_74768_a("Item1", 0);
            tag.func_74768_a("Item2", 0);
            tag.func_74768_a("Item3", 0);
            tag.func_74768_a("Item4", 0);
            tag.func_74768_a("Item5", 0);
            tag.func_74768_a("Item6", 0);
            tag.func_74768_a("Energy", 0);
            this.analysed = 1;
        }
    }

    private void add(ItemStack item, int slotID) {
        if (item != null && this.canAnalyse()) {
            this.slots[slotID] = new ItemStack(item.func_77973_b(), 1, item.func_77960_j());
        }
    }

    private boolean canAnalyse() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == Calculator.circuitBoard && this.slots[2] == null && this.slots[3] == null && this.slots[4] == null && this.slots[5] == null && this.slots[6] == null && this.slots[7] == null) {
            return true;
        }
        if (this.slots[0] == null) {
            this.stable = 0;
            return false;
        }
        return false;
    }

    public static int itemEnergy(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1000;
        }
        if (n == 2) {
            return 500;
        }
        if (n == 3) {
            return 250;
        }
        if (n == 4) {
            return 10000;
        }
        if (n == 5) {
            return 5000;
        }
        if (n == 6) {
            return 100000;
        }
        if (n == 7) {
            return 100;
        }
        if (n == 8) {
            return 175;
        }
        if (n == 9) {
            return 400;
        }
        if (n == 10) {
            return 750;
        }
        if (n == 11) {
            return 800;
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    private int stable(int par) {
        if (this.slots[par] != null && this.slots[par].func_77942_o() && this.slots[par].func_77973_b() instanceof IStability) {
            IStability item = (IStability)this.slots[par].func_77973_b();
            boolean stable = item.getStability(this.slots[par]);
            if (!stable) {
                item.onFalse(this.slots[par]);
            }
            return stable ? 1 : 0;
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack.func_77973_b() == Calculator.circuitBoard) {
                return true;
            }
            if (stack.func_77973_b() == Calculator.circuitBoard) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return slot != 1;
    }

    public boolean canAddUpgrades() {
        return true;
    }

    public boolean canAddUpgrades(int type) {
        return type == 2;
    }

    public int getUpgrades(int type) {
        switch (type) {
            case 2: {
                return this.vUpgrade;
            }
        }
        return 0;
    }

    public int getMaxUpgrades(int type) {
        switch (type) {
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public void incrementUpgrades(int type, int increment) {
        if (type == 2) {
            this.vUpgrade += increment;
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.stable = nbt.func_74765_d("Stable");
            this.vUpgrade = nbt.func_74765_d("vUpgrade");
            if (type == NBTHelper.SyncType.SAVE) {
                this.analysed = nbt.func_74765_d("analysed");
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74777_a("Stable", (short)this.stable);
            nbt.func_74777_a("vUpgrade", (short)this.vUpgrade);
            if (type == NBTHelper.SyncType.SAVE) {
                nbt.func_74777_a("analysed", (short)this.analysed);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (this.vUpgrade != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.void") + ": " + FontHelper.translate((String)"circuit.installed"));
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ItemStack[] circuits = new ItemStack[1];
        if (this.getUpgrades(2) != 0) {
            circuits[0] = new ItemStack(Calculator.voidUpgrade, 1);
        }
        return circuits;
    }
}

