/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.core.helpers.SonarHelper;

public class TileEntityFluxHandler
extends TileEntityFlux {
    protected TileEntity[] handlers = new TileEntity[6];

    public int pullEnergy(int export, boolean simulate) {
        for (int i = 0; i < 6; ++i) {
            TileEntity target = this.handlers[i];
            if (target == null) continue;
            if (target instanceof IEnergyProvider) {
                export -= ((IEnergyProvider)target).extractEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], export, simulate);
                continue;
            }
            if (!(target instanceof IEnergySource)) continue;
            if (simulate) {
                export = (int)((double)export - ((IEnergySource)target).getOfferedEnergy() * 4.0);
                continue;
            }
            int remove = (int)Math.min(((IEnergySource)target).getOfferedEnergy(), (double)(export / 4));
            export -= remove * 4;
            ((IEnergySource)target).drawEnergy((double)remove);
        }
        return export;
    }

    public int pushEnergy(int recieve, boolean simulate) {
        for (int i = 0; i < 6; ++i) {
            TileEntity target = this.handlers[i];
            if (target == null) continue;
            if (target instanceof IEnergyReceiver) {
                recieve -= ((IEnergyReceiver)target).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], recieve, simulate);
                continue;
            }
            if (!(target instanceof IEnergySink)) continue;
            recieve = simulate ? (int)((double)recieve - ((IEnergySink)target).getDemandedEnergy() * 4.0) : (int)((double)recieve - ((double)recieve - ((IEnergySink)target).injectEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], (double)(recieve / 4), 128.0) * 4.0));
        }
        return recieve;
    }

    public void updateAdjacentHandlers() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity te = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)dir);
            if (te == null || te instanceof TileEntityFlux) continue;
            this.handlers[i] = SonarHelper.isEnergyHandlerFromSide((TileEntity)te, (ForgeDirection)dir.getOpposite()) ? te : null;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateAdjacentHandlers();
    }
}

