/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.recipes;

import cpw.mods.fml.common.FMLLog;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.calculator.mod.Calculator;
import sonar.core.helpers.RecipeHelper;

public class RecipeRegistry {
    private static final Map<Integer, Object[]> blocked = new THashMap();
    private static final List<Object[]> unblocked = new ArrayList<Object[]>();
    private static final List<Object[]> scientific = new ArrayList<Object[]>();
    private static final List<Object[]> atomic = new ArrayList<Object[]>();
    private static final List<Object[]> flawless = new ArrayList<Object[]>();
    private static final Map<String, List<Object[]>> machines = new THashMap();

    public static void clearRecipes() {
        blocked.clear();
        unblocked.clear();
        scientific.clear();
        atomic.clear();
        flawless.clear();
        machines.clear();
    }

    public static void registerRecipes() {
        RecipeRegistry.addStandardRecipes();
        RecipeRegistry.addScientificRecipes();
        RecipeRegistry.addAtomicRecipes();
        RecipeRegistry.addFlawlessRecipes();
    }

    public static void registerCalculatorRecipe(Object ... objects) {
        if (objects.length != 4) {
            Calculator.logger.warn("Calculator Recipes - Invalid Recipe Size!");
            return;
        }
        RecipeRegistry.rearrangeCalculatorRecipe(objects);
    }

    public static void registerScientificRecipe(Object ... objects) {
        if (objects.length != 3) {
            Calculator.logger.warn("Scientific Recipes - Invalid Recipe Size!");
            return;
        }
        scientific.add(objects);
    }

    public static void registerAtomicRecipe(Object ... objects) {
        if (objects.length != 4) {
            Calculator.logger.warn("Atomic Recipes - Invalid Recipe Size!");
            return;
        }
        atomic.add(objects);
    }

    public static void registerFlawlessRecipe(Object ... objects) {
        if (objects.length != 5) {
            FMLLog.warning((String)"Flawless Recipes - Invalid Recipe Size!", (Object[])new Object[0]);
            return;
        }
        flawless.add(objects);
    }

    private static void addStandardRecipes() {
        RecipeRegistry.registerCalculatorRecipe(Calculator.baby_grenade, Calculator.grenadecasing, Blocks.field_150335_W, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.reinforcedstoneBlock, "cobblestone", "plankWood", false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.reinforcedstoneBlock, 4), "cobblestone", "logWood", false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.wrench, Calculator.reinforced_sword, Calculator.reinforced_pickaxe, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.reinforceddirtBlock, Blocks.field_150346_d, "plankWood", false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.reinforceddirtBlock, 4), Blocks.field_150346_d, "logWood", false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.enrichedgold, 4), "ingotGold", "dustRedstone", false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.reinforcediron_ingot, "ingotIron", Calculator.reinforcedstoneBlock, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.enriched_coal, Items.field_151044_h, "dustRedstone", false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.broccoliSeeds, Items.field_151014_N, Items.field_151080_bb, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.sickle, Calculator.reinforced_shovel, Calculator.reinforced_axe, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.scarecrow, Blocks.field_150423_aK, Blocks.field_150407_cf, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.basic_lantern, Blocks.field_150478_aa, Calculator.reinforcediron_ingot, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.gas_lantern_off, Calculator.basic_lantern, Calculator.basic_lantern, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.prunaeSeeds, Calculator.enriched_coal, Items.field_151014_N, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.enriched_coal, Calculator.coal_dust, Calculator.coal_dust, false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.reinforcedstoneBrick, 2), Calculator.reinforcedstoneBlock, Calculator.reinforcedstoneBlock, false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.stableglassBlock, 2), "blockGlass", "blockGlass", false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.stablestoneBlock, 2), Calculator.reinforcedstoneBrick, Calculator.reinforcedstoneBrick, false);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.reinforceddirtBrick, 2), Calculator.reinforceddirtBlock, Calculator.reinforceddirtBlock, false);
        RecipeRegistry.registerCalculatorRecipe(Calculator.rainSensor, Blocks.field_150453_bW, Items.field_151133_ar, false);
    }

    private static void addScientificRecipes() {
        RecipeRegistry.registerScientificRecipe(Calculator.enriched_coal, Calculator.enrichedgold_ingot, Calculator.purified_coal);
        RecipeRegistry.registerScientificRecipe("ingotIron", "dustRedstone", Calculator.redstone_ingot);
        RecipeRegistry.registerScientificRecipe("gemDiamond", Calculator.reinforcediron_ingot, new ItemStack(Calculator.weakeneddiamond, 4));
        RecipeRegistry.registerScientificRecipe(Calculator.baby_grenade, Calculator.baby_grenade, Calculator.grenade);
        RecipeRegistry.registerScientificRecipe(Calculator.enriched_coal, Items.field_151129_at, Calculator.firecoal);
        RecipeRegistry.registerScientificRecipe(Calculator.large_amethyst, "treeSapling", Calculator.AmethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.amethystLeaf, Calculator.AmethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.small_amethyst, Calculator.AmethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.amethystLog, Calculator.AmethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.itemCalculator, Calculator.redstone_ingot, Calculator.itemTerrainModule);
        RecipeRegistry.registerScientificRecipe(Calculator.itemEnergyModule, Calculator.small_amethyst, Calculator.starchextractor);
        RecipeRegistry.registerScientificRecipe(Calculator.powerCube, Calculator.purified_coal, Calculator.itemEnergyModule);
        RecipeRegistry.registerScientificRecipe(Calculator.reinforced_iron_block, Items.field_151061_bv, Calculator.fluxPlug);
        RecipeRegistry.registerScientificRecipe(Calculator.redstone_ingot, Items.field_151079_bi, Calculator.fluxPoint);
    }

    private static void addAtomicRecipes() {
        RecipeRegistry.registerAtomicRecipe("ingotIron", "dustRedstone", "ingotIron", Calculator.itemScientificCalculator);
        RecipeRegistry.registerAtomicRecipe("gemDiamond", Calculator.atomic_binder, "gemDiamond", Calculator.flawlessdiamond);
        RecipeRegistry.registerAtomicRecipe("gemDiamond", Items.field_151072_bj, "gemDiamond", Calculator.flawlessfirediamond);
        RecipeRegistry.registerAtomicRecipe(Items.field_151072_bj, Calculator.flawlessdiamond, Items.field_151072_bj, Calculator.flawlessfirediamond);
        RecipeRegistry.registerAtomicRecipe(Blocks.field_150377_bs, Calculator.electricdiamond, Blocks.field_150343_Z, Calculator.enddiamond);
        RecipeRegistry.registerAtomicRecipe(Calculator.AmethystSapling, Blocks.field_150377_bs, Calculator.tanzaniteSapling, Calculator.PearSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.itemScientificCalculator, Calculator.atomic_binder, Calculator.redstone_ingot, Calculator.itemAdvancedTerrainModule);
        RecipeRegistry.registerAtomicRecipe(Calculator.tanzaniteLog, Calculator.atomic_binder, Calculator.tanzaniteLeaf, Calculator.tanzaniteSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.large_tanzanite, Calculator.atomic_binder, "treeSapling", Calculator.tanzaniteSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.healthprocessor, Calculator.itemEnergyModule, Calculator.hungerprocessor, Calculator.itemNutritionModule);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 4), Calculator.atomic_binder, "dustEnrichedGold", new ItemStack(Calculator.speedUpgrade, 4));
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 5), Calculator.atomic_binder, "dustEnrichedGold", new ItemStack(Calculator.energyUpgrade, 4));
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 6), Calculator.atomic_binder, "dustEnrichedGold", Calculator.voidUpgrade);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 9), Calculator.redstoneextractor, Calculator.large_tanzanite, Calculator.glowstoneextractor);
        RecipeRegistry.registerAtomicRecipe(Calculator.redstone_ingot, Calculator.starchextractor, Calculator.redstone_ingot, Calculator.redstoneextractor);
        RecipeRegistry.registerAtomicRecipe(Calculator.itemEnergyModule, Calculator.flawlessfirediamond, Calculator.itemEnergyModule, Calculator.conductorMast);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforced_iron_block, Blocks.field_150486_ae, Calculator.reinforced_iron_block, Calculator.storageChamber);
        RecipeRegistry.registerAtomicRecipe(Calculator.reassemblyChamber, Calculator.flawlessdiamond, Calculator.restorationChamber, Calculator.processingChamber);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Blocks.field_150486_ae, Calculator.reinforcediron_ingot, Calculator.itemStorageModule);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Calculator.electricdiamond, Calculator.reinforcediron_ingot, Calculator.transmitter);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Calculator.flawlessfirediamond, Calculator.reinforcediron_ingot, new ItemStack(Calculator.weatherStation, 4));
    }

    private static void addFlawlessRecipes() {
        RecipeRegistry.registerFlawlessRecipe(Calculator.PearSapling, Calculator.enddiamond, Calculator.enddiamond, Blocks.field_150377_bs, Calculator.diamondSapling);
        RecipeRegistry.registerFlawlessRecipe("ingotGold", "ingotGold", "ingotGold", "ingotGold", Items.field_151045_i);
        RecipeRegistry.registerFlawlessRecipe("gemDiamond", "gemDiamond", "gemDiamond", "gemDiamond", Items.field_151166_bC);
        RecipeRegistry.registerFlawlessRecipe("ingotIron", "ingotIron", "ingotIron", "ingotIron", Items.field_151079_bi);
        RecipeRegistry.registerFlawlessRecipe("logWood", "logWood", "logWood", "logWood", Blocks.field_150343_Z);
        RecipeRegistry.registerFlawlessRecipe(Blocks.field_150343_Z, Blocks.field_150343_Z, Blocks.field_150343_Z, Blocks.field_150343_Z, Calculator.purifiedobsidianBlock);
        RecipeRegistry.registerFlawlessRecipe(Calculator.broccoli, Calculator.broccoli, Calculator.broccoli, Calculator.broccoli, Calculator.fiddledewFruit);
        RecipeRegistry.registerFlawlessRecipe(Calculator.itemEnergyModule, Calculator.itemCalculator, Calculator.itemCalculator, Calculator.itemEnergyModule, Calculator.itemLocatorModule);
        RecipeRegistry.registerFlawlessRecipe(Calculator.flawlessdiamond, "blockGlass", "blockGlass", Calculator.flawlessdiamond, new ItemStack(Calculator.flawlessGlass, 4));
        RecipeRegistry.registerFlawlessRecipe(Calculator.circuitBoard, Calculator.enriched_coal, Calculator.enriched_coal, Calculator.circuitBoard, new ItemStack(Calculator.controlled_Fuel, 4));
        RecipeRegistry.registerFlawlessRecipe(Calculator.gas_lantern_off, new ItemStack(Calculator.circuitBoard, 1, 8), new ItemStack(Calculator.circuitBoard, 1, 8), Calculator.gas_lantern_off, Calculator.carbondioxideGenerator);
        RecipeRegistry.registerFlawlessRecipe(Items.field_151065_br, Items.field_151065_br, Items.field_151065_br, Items.field_151065_br, Items.field_151072_bj);
        RecipeRegistry.registerFlawlessRecipe(Items.field_151072_bj, Items.field_151072_bj, Items.field_151072_bj, Items.field_151072_bj, Items.field_151073_bk);
    }

    private static void rearrangeCalculatorRecipe(Object ... objects) {
        if (objects[3] == null || ((Boolean)objects[3]).booleanValue()) {
            Object[] recipe = new Object[]{objects[1], objects[2], objects[0]};
            blocked.put(blocked.size(), recipe);
        } else {
            Object[] recipe = new Object[]{objects[1], objects[2], objects[0]};
            unblocked.add(recipe);
        }
    }

    public static int getBlockedSize() {
        return blocked.size();
    }

    public static int getUnblockedSize() {
        return unblocked.size();
    }

    public static int getScientificSize() {
        return scientific.size();
    }

    public static int getAtomicSize() {
        return atomic.size();
    }

    public static int getFlawlessSize() {
        return flawless.size();
    }

    public static class ConductorMastPowerRecipes
    extends RecipeHelper {
        private static final ConductorMastPowerRecipes INSTANCE = new ConductorMastPowerRecipes();

        public static ConductorMastPowerRecipes instance() {
            return INSTANCE;
        }

        ConductorMastPowerRecipes() {
            super(1, 1, true);
        }

        public void addRecipes() {
            this.addRecipe(new Object[]{new ItemStack(Calculator.electricdiamond), 10000});
            this.addRecipe(new Object[]{new ItemStack(Calculator.itemScientificCalculator), 2000});
            this.addRecipe(new Object[]{new ItemStack(Calculator.electric_diamond_block), 90000});
        }

        public int getPowercost(ItemStack input) {
            Object[] output = this.getOutputRaw(new ItemStack[]{input});
            if (output == null) {
                return 0;
            }
            return (Integer)output[0];
        }

        public String getRecipeID() {
            return "ConductorMastPower";
        }
    }

    public static class ConductorMastItemRecipes
    extends RecipeHelper {
        private static final ConductorMastItemRecipes INSTANCE = new ConductorMastItemRecipes();

        public static ConductorMastItemRecipes instance() {
            return INSTANCE;
        }

        public ConductorMastItemRecipes() {
            super(1, 1, true);
        }

        public void addRecipes() {
            this.addRecipe(new Object[]{Calculator.flawlessfirediamond, new ItemStack(Calculator.electricdiamond)});
            this.addRecipe(new Object[]{Calculator.itemCalculator, new ItemStack(Calculator.itemScientificCalculator)});
            this.addRecipe(new Object[]{Calculator.flawless_fire_block, new ItemStack(Calculator.electric_diamond_block)});
        }

        public Map<ItemStack, ItemStack> getRecipeStacks() {
            HashMap<ItemStack, ItemStack> map = new HashMap<ItemStack, ItemStack>();
            for (Map.Entry entry : this.recipeList.entrySet()) {
                map.put((ItemStack)((Object[])entry.getKey())[0], (ItemStack)((Object[])entry.getValue())[0]);
            }
            return map;
        }

        public String getRecipeID() {
            return "ConductorMastItem";
        }
    }

    public static class FlawlessRecipes
    extends RecipeHelper {
        private static final FlawlessRecipes recipes = new FlawlessRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public FlawlessRecipes() {
            super(4, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < flawless.size(); ++i) {
                this.addRecipe((Object[])flawless.get(i));
            }
        }

        public String getRecipeID() {
            return "Flawless";
        }
    }

    public static class AtomicRecipes
    extends RecipeHelper {
        private static final AtomicRecipes recipes = new AtomicRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public AtomicRecipes() {
            super(3, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < atomic.size(); ++i) {
                this.addRecipe((Object[])atomic.get(i));
            }
        }

        public String getRecipeID() {
            return "Atomic";
        }
    }

    public static class ScientificRecipes
    extends RecipeHelper {
        private static final ScientificRecipes recipes = new ScientificRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public ScientificRecipes() {
            super(2, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < scientific.size(); ++i) {
                this.addRecipe((Object[])scientific.get(i));
            }
        }

        public String getRecipeID() {
            return "Scientific";
        }
    }

    public static class CalculatorRecipes
    extends RecipeHelper {
        private static final CalculatorRecipes recipes = new CalculatorRecipes();
        public int currentRecipe = 0;

        public static final CalculatorRecipes instance() {
            return recipes;
        }

        public CalculatorRecipes() {
            super(2, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < unblocked.size(); ++i) {
                this.addRecipe((Object[])unblocked.get(i));
            }
        }

        public void writeToNBT(NBTTagCompound nbt, Map<Integer, Integer> unblocked, String tag) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<Integer, Integer> recipes : unblocked.entrySet()) {
                if (recipes.getValue() == 0) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("ID", recipes.getKey().intValue());
                compound.func_74768_a("TYPE", recipes.getValue().intValue());
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a(tag, (NBTBase)list);
        }

        public Map<Integer, Integer> readFromNBT(NBTTagCompound nbt, String tag) {
            NBTTagList list = nbt.func_150295_c(tag, 10);
            THashMap recipes = new THashMap();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                recipes.put(compound.func_74762_e("ID"), compound.func_74762_e("TYPE"));
            }
            return recipes;
        }

        public void unblockStack(Map<Integer, Integer> unblocked, ItemStack stack) {
            int i;
            if (unblocked == null) {
                unblocked = new THashMap();
            }
            List<Integer> inputs = this.getInputIDs(stack);
            List<Integer> outputs = this.getOutputIDs(stack);
            if (inputs != null) {
                for (i = 0; i < inputs.size(); ++i) {
                    if (unblocked.get(i) == null || unblocked.get(i) instanceof Integer && (Integer)unblocked.get(i) == 0) {
                        unblocked.put(i, 1);
                        continue;
                    }
                    if ((Integer)unblocked.get(i) != 1) continue;
                    unblocked.replace(i, 2);
                }
            }
            if (outputs != null) {
                for (i = 0; i < outputs.size(); ++i) {
                    int current = (Integer)unblocked.get(i);
                    if (current == 2) continue;
                    unblocked.replace(i, 2);
                }
            }
        }

        public List<Integer> getInputIDs(ItemStack input) {
            if (input == null) {
                return null;
            }
            Iterator iterator = this.recipeList.entrySet().iterator();
            int pos = 0;
            ArrayList<Integer> positions = new ArrayList<Integer>();
            do {
                if (!iterator.hasNext()) {
                    return positions;
                }
                Map.Entry entry = iterator.next();
                ++pos;
                if (this.containsStack(input, (Object[])entry.getKey(), false) == -1) continue;
                positions.add(pos);
            } while (iterator.hasNext());
            return positions;
        }

        public List<Integer> getOutputIDs(ItemStack output) {
            if (output == null) {
                return null;
            }
            Iterator iterator = this.recipeList.entrySet().iterator();
            int pos = 0;
            ArrayList<Integer> positions = new ArrayList<Integer>();
            do {
                if (!iterator.hasNext()) {
                    return positions;
                }
                Map.Entry entry = iterator.next();
                ++pos;
                if (this.containsStack(output, (Object[])entry.getKey(), false) == -1) continue;
                positions.add(pos);
            } while (iterator.hasNext());
            return positions;
        }

        public String getRecipeID() {
            return "Calculator";
        }
    }
}

