/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.item.calculators.SonarCalculator;
import sonar.core.common.item.InventoryItem;
import sonar.core.inventory.IItemInventory;

public class WIPSmeltingModule
extends SonarCalculator
implements IItemInventory {
    public int syncCook;
    public int syncEnergy;
    public int requiredEnergy = 1000;
    public int speed = 1000;

    public WIPSmeltingModule() {
        this.capacity = CalculatorConfig.getInteger("Standard Machine");
        this.maxReceive = CalculatorConfig.getInteger("Standard Machine");
        this.maxExtract = CalculatorConfig.getInteger("Standard Machine");
        this.maxTransfer = CalculatorConfig.getInteger("Standard Machine");
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        return this.onCalculatorRightClick(itemstack, world, player, 38);
    }

    public static int getIntegerTag(ItemStack stack, String tag) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a(tag, 0);
        }
        return stack.func_77978_p().func_74762_e(tag);
    }

    public int cookTime(ItemStack stack) {
        return WIPSmeltingModule.getIntegerTag(stack, "cookTime");
    }

    public static void setCookTime(ItemStack stack, int burn) {
        WIPSmeltingModule.setIntegerTag(stack, "cookTime", burn);
    }

    public static int itemBurnTime(ItemStack stack) {
        return WIPSmeltingModule.getIntegerTag(stack, "cookTime");
    }

    public static void setItemBurnTime(ItemStack stack, int burn) {
        WIPSmeltingModule.setIntegerTag(stack, "cookTime", burn);
    }

    public static void setIntegerTag(ItemStack stack, String tag, int value) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a(tag, 0);
        }
        nbtData.func_74768_a(tag, value);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par, boolean bool) {
        int energy = this.requiredEnergy / this.speed;
        int currentCook = this.cookTime(stack);
        if (currentCook > 0) {
            ++currentCook;
            this.extractEnergy(stack, energy, false);
        }
        if (this.canCook(stack)) {
            if (currentCook == 0) {
                ++currentCook;
                this.extractEnergy(stack, energy, false);
            }
            if (currentCook == this.speed) {
                currentCook = 0;
                this.cookItem(stack);
            }
        } else if (currentCook != 0) {
            currentCook = 0;
        }
        if (currentCook != this.cookTime(stack)) {
            WIPSmeltingModule.setCookTime(stack, currentCook);
        }
    }

    public void cookItem(ItemStack stack) {
        InventoryItem inv = this.getInventory(stack);
        ItemStack itemstack = this.recipe(inv.func_70301_a(0));
        if (itemstack != null) {
            if (inv.func_70301_a(2) == null) {
                inv.func_70299_a(2, itemstack.func_77946_l());
            } else if (inv.func_70301_a(2).func_77969_a(itemstack)) {
                this.getInventory(stack).func_70298_a(2, itemstack.field_77994_a);
            }
            this.getInventory(stack).func_70298_a(0, 1);
        }
    }

    public boolean canCook(ItemStack stack) {
        int currentCook = this.cookTime(stack);
        InventoryItem inv = this.getInventory(stack);
        if (inv.func_70301_a(0) == null) {
            return false;
        }
        if (currentCook == 0 && this.getEnergyStored(stack) < this.requiredEnergy) {
            return false;
        }
        ItemStack itemstack = this.recipe(inv.func_70301_a(0));
        if (itemstack == null) {
            return false;
        }
        if (inv.func_70301_a(2) != null) {
            if (!inv.func_70301_a(2).func_77969_a(itemstack)) {
                return false;
            }
            if (inv.func_70301_a((int)2).field_77994_a + itemstack.field_77994_a > inv.func_70301_a(2).func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public ItemStack recipe(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public InventoryItem getInventory(ItemStack stack) {
        return new SmeltingInventory(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int storedItems;
        super.func_77624_a(stack, player, list, par4);
        if (stack.func_77942_o() && (storedItems = this.getInventory(stack).getItemsStored(stack)) != 0) {
            list.add("Stored Stacks: " + storedItems);
        }
    }

    public static class SmeltingInventory
    extends InventoryItem {
        public SmeltingInventory(ItemStack stack) {
            super(stack, 3, "Items");
        }
    }
}

