/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.util.transformations;

import net.minecraftforge.common.util.ForgeDirection;

public enum Directions {
    NegY(ForgeDirection.DOWN),
    PosY(ForgeDirection.UP),
    NegZ(ForgeDirection.NORTH),
    PosZ(ForgeDirection.SOUTH),
    NegX(ForgeDirection.WEST),
    PosX(ForgeDirection.EAST),
    Null(null);

    public int deltaX;
    public int deltaY;
    public int deltaZ;
    public int oppositeOrdinal;
    static final Directions[] valid;

    private Directions(ForgeDirection Direction) {
        if (Direction != null) {
            this.deltaX = Direction.offsetX;
            this.deltaY = Direction.offsetY;
            this.deltaZ = Direction.offsetZ;
            this.oppositeOrdinal = Direction.getOpposite().ordinal();
        }
    }

    public Directions opposite() {
        return Directions.values()[this.oppositeOrdinal];
    }

    public static Directions[] validDirections() {
        return valid;
    }

    static {
        valid = new Directions[]{NegY, PosY, NegZ, PosZ, NegX, PosX};
    }
}

