/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import me.planetguy.remaininmotion.drive.BlockCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageMotor;
import me.planetguy.remaininmotion.drive.gui.Buttons;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriageObstructionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.MultiTypeCarriageUtil;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCarriageEngine
extends TileEntityCarriageDrive {
    @Override
    public CarriagePackage GeneratePackage(TileEntity carriage, Directions CarriageDirection, Directions MotionDirection) throws CarriageMotionException {
        if (this.Anchored() && MotionDirection == CarriageDirection.opposite()) {
            throw new CarriageMotionException("motor cannot pull carriage into itself");
        }
        CarriagePackage Package2 = new CarriagePackage(this, carriage, MotionDirection);
        if (!this.Anchored()) {
            Package2.AddBlock(Package2.driveRecord);
            if (MotionDirection != CarriageDirection) {
                Package2.AddPotentialObstruction(Package2.driveRecord.NextInDirection(MotionDirection));
            }
        }
        MultiTypeCarriageUtil.fillPackage(Package2, carriage);
        if (this.Anchored()) {
            if (Package2.Body.contains(Package2.driveRecord)) {
                throw new CarriageMotionException("carriage is attempting to move motor");
            }
            if (Package2.Body.contains(Package2.driveRecord.NextInDirection(MotionDirection.opposite()))) {
                throw new CarriageObstructionException("carriage motion is obstructed by motor", this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        Package2.Finalize();
        return Package2;
    }

    @Override
    public boolean Anchored() {
        return this.isAnchored;
    }

    @Override
    public void WriteCommonRecord(NBTTagCompound TagCompound) {
        super.WriteCommonRecord(TagCompound);
    }

    public void setConfigurationSuper(long flags, EntityPlayerMP changer) {
        super.setConfiguration(flags, changer);
        this.isAnchored = (flags & (long)(1 << Buttons.MOVE_WITH_CARRIAGE.ordinal() + 3)) == 0L;
    }

    @Override
    public void setConfiguration(long flags, EntityPlayerMP changer) {
        this.setConfigurationSuper(flags, changer);
        if (this.isAnchored) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockCarriageDrive.Types.Motor.ordinal(), 2);
            TileEntityCarriageMotor te = new TileEntityCarriageMotor();
            NBTTagCompound tag = new NBTTagCompound();
            this.func_145841_b(tag);
            te.func_145839_a(tag);
            this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)te);
        }
    }
}

