/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.storage.sorters.CountItemSorter;
import mcjty.rftools.blocks.storage.sorters.DimletRarityItemSorter;
import mcjty.rftools.blocks.storage.sorters.DimletTypeItemSorter;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.blocks.storage.sorters.NameItemSorter;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.storage.StorageTypeItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class DimletTypeItem
extends StorageTypeItem {
    private static final Pattern PATTERN = Pattern.compile(" Dimlet", 16);
    private List<ItemSorter> sorters = null;

    public DimletTypeItem() {
        this.func_77625_d(16);
    }

    @Override
    public List<ItemSorter> getSorters() {
        if (this.sorters == null) {
            this.sorters = new ArrayList<ItemSorter>();
            this.sorters.add(new NameItemSorter());
            this.sorters.add(new CountItemSorter());
            this.sorters.add(new DimletTypeItemSorter());
            this.sorters.add(new DimletRarityItemSorter());
        }
        return this.sorters;
    }

    @Override
    public String getLongLabel(ItemStack stack) {
        DimletEntry entry;
        DimletKey key;
        if (stack.func_77973_b() == DimletSetup.knownDimlet && (key = KnownDimletConfiguration.getDimletKey(stack, null)) != null && (entry = KnownDimletConfiguration.getEntry(key)) != null) {
            return PATTERN.matcher(stack.func_82833_r()).replaceAll("") + " (R" + entry.getRarity() + ")";
        }
        return stack.func_82833_r();
    }

    @Override
    public String getShortLabel(ItemStack stack) {
        return stack.func_82833_r();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This module extends the Modular Storage block");
            list.add(EnumChatFormatting.WHITE + "with Dimlet specific capabilities");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }
}

