/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class CounterTileEntity
extends GenericTileEntity {
    public static final String CMD_SETCOUNTER = "setCounter";
    public static final String CMD_SETCURRENT = "setCurrent";
    private boolean prevIn = false;
    private int counter = 1;
    private int current = 0;
    private boolean redstoneOut = false;

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCurrent(int current) {
        this.current = current;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canUpdate() {
        return false;
    }

    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn((int)meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        boolean newout = false;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = true;
            }
            this.func_70296_d();
            if (newout != this.redstoneOut) {
                this.redstoneOut = newout;
                this.notifyBlockUpdate();
            }
        }
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        return BlockTools.setRedstoneSignalOut((int)meta, (boolean)this.redstoneOut);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut = tagCompound.func_74767_n("rs");
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.counter = tagCompound.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = tagCompound.func_74762_e("current");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("rs", this.redstoneOut);
        tagCompound.func_74757_a("prevIn", this.prevIn);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("counter", this.counter);
        tagCompound.func_74768_a("current", this.current);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETCOUNTER.equals(command)) {
            this.setCounter(args.get("counter").getInteger());
            return true;
        }
        if (CMD_SETCURRENT.equals(command)) {
            this.setCurrent(args.get("current").getInteger());
            return true;
        }
        return false;
    }
}

