/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.handlers;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.util.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Property;

public class ConfigAdaptor {
    private boolean enabled;
    private int lastBuild;
    private int currentBuild;
    private Map<String, List<AdaptableValue>> adaptableValues = new HashMap<String, List<AdaptableValue>>();
    private List<String> changes = new ArrayList<String>();

    public ConfigAdaptor(boolean enabled) {
        this.enabled = enabled;
        String lastVersion = IronBackpacks.proxy.getModVersion();
        if (lastVersion != null) {
            Logger.info("Version: " + lastVersion);
            try {
                String last = lastVersion.substring(lastVersion.lastIndexOf(45) + 1);
                Logger.info("Version2: " + last);
                this.lastBuild = Integer.parseInt(last);
            }
            catch (NumberFormatException e) {
                this.enabled = false;
            }
        }
    }

    public <T> void adaptProperty(Property prop, T val) {
        if (!this.enabled) {
            return;
        }
        String name = prop.getName();
        if (!this.adaptableValues.containsKey(name)) {
            return;
        }
        AdaptableValue bestValue = null;
        for (AdaptableValue value : this.adaptableValues.get(name)) {
            if (value.version >= this.lastBuild || bestValue != null && value.version <= bestValue.version) continue;
            bestValue = value;
        }
        if (bestValue != null) {
            Object expected = bestValue.value;
            String def = prop.getDefault();
            if (this.areEqualNumbers(val, expected) && !this.areEqualNumbers(val, def)) {
                prop.setValue(def.toString());
                this.changes.add(" " + prop.getName() + ": " + val + " -> " + def);
            }
        }
    }

    public <T> void addMapping(int version, String key, T val) {
        List<Object> list;
        if (!this.enabled) {
            return;
        }
        AdaptableValue<T> adapt = new AdaptableValue<T>(version, val);
        if (!this.adaptableValues.containsKey(key)) {
            list = new ArrayList();
            this.adaptableValues.put(key, list);
        }
        list = this.adaptableValues.get(key);
        list.add(adapt);
    }

    public boolean areEqualNumbers(Object v1, Object v2) {
        double epsilon = 1.0E-6;
        float v1f = ((Number)v1).floatValue();
        float v2f = v2 instanceof String ? Float.parseFloat((String)v2) : ((Number)v2).floatValue();
        return (double)Math.abs(v1f - v2f) < epsilon;
    }

    public void tellChanges(EntityPlayer player) {
        if (this.changes.size() == 0) {
            return;
        }
        player.func_146105_b(new ChatComponentTranslation("botaniamisc.adaptativeConfigChanges", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
        for (String change : this.changes) {
            player.func_145747_a(new ChatComponentText(change).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.LIGHT_PURPLE)));
        }
    }

    public void addMappingInt(int version, String key, int val) {
        this.addMapping(version, key, val);
    }

    public void addMappingDouble(int version, String key, double val) {
        this.addMapping(version, key, val);
    }

    public void addMappingBool(int version, String key, boolean val) {
        this.addMapping(version, key, val);
    }

    public void adaptPropertyInt(Property prop, int val) {
        this.adaptProperty(prop, val);
    }

    public void adaptPropertyDouble(Property prop, double val) {
        this.adaptProperty(prop, val);
    }

    public void adaptPropertyBool(Property prop, boolean val) {
        this.adaptProperty(prop, val);
    }

    public static String getLatestFilenameFromCurse(String urlString) {
        try {
            while (urlString != null && !urlString.isEmpty()) {
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                urlString = connection.getHeaderField("Location");
                if (urlString == null || !urlString.endsWith(".jar") && !urlString.endsWith(".zip")) continue;
                return urlString.substring(urlString.lastIndexOf("/") + 1);
            }
        }
        catch (MalformedURLException e) {
            Logger.error("Malformed URL was given when searching in Curse database!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLatestFilenameFromGithub(String urlString) {
        try {
            while (urlString != null && !urlString.isEmpty()) {
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                urlString = connection.getHeaderField("Location");
                if (urlString == null || !urlString.endsWith(".jar") && !urlString.endsWith(".zip")) continue;
                return urlString.substring(urlString.lastIndexOf("/") + 1);
            }
        }
        catch (MalformedURLException e) {
            Logger.error("Malformed URL was given when searching in Curse database!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class AdaptableValue<T> {
        public final int version;
        public final T value;
        public final Class<? extends T> valueType;

        public AdaptableValue(int version, T value) {
            this.version = version;
            this.value = value;
            this.valueType = value.getClass();
        }
    }
}

