/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.worldgen.structures.Structure;

public class WatchTowerSmall
extends Structure {
    int towerSize = 3;

    public WatchTowerSmall(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int towerSize) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.towerSize = towerSize;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        if (sizeX >= this.towerSize + 2) {
            posX += (sizeX - this.towerSize) / 2;
        }
        if (sizeZ >= this.towerSize + 2) {
            posZ += (sizeZ - this.towerSize) / 2;
        }
        for (int y = 1; y < sizeY - 1; ++y) {
            world.func_147449_b(posX, posY + y, posZ, Blocks.field_150422_aJ);
            world.func_147449_b(posX + this.towerSize - 1, posY + y, posZ, Blocks.field_150422_aJ);
            world.func_147449_b(posX, posY + y, posZ + this.towerSize - 1, Blocks.field_150422_aJ);
            world.func_147449_b(posX + this.towerSize - 1, posY + y, posZ + this.towerSize - 1, Blocks.field_150422_aJ);
            if (y >= sizeY - 3) continue;
            for (int x = 1; x < this.towerSize - 1; ++x) {
                for (int z = 1; z < this.towerSize - 1; ++z) {
                    world.func_147449_b(posX + x, posY + y, posZ + z, Blocks.field_150344_f);
                }
            }
        }
        BlockUtils.fillBlocksHollow(world, posX, posY + sizeY - 4, posZ, this.towerSize, 2, this.towerSize, Blocks.field_150422_aJ);
        BlockUtils.fillBlocks(world, posX, posY + sizeY - 1, posZ, this.towerSize, 1, this.towerSize, TGBlocks.camoNetRoof);
        int xoffset = 0;
        int zoffset = 0;
        int meta = 0;
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = 1;
                meta = 4;
                break;
            }
            case 1: {
                xoffset = 1;
                zoffset = 0;
                meta = 2;
                break;
            }
            case 2: {
                xoffset = this.towerSize - 1;
                zoffset = this.towerSize - 2;
                meta = 5;
                break;
            }
            case 3: {
                xoffset = this.towerSize - 2;
                zoffset = this.towerSize - 1;
                meta = 3;
            }
        }
        for (int y = 1; y < sizeY - 3; ++y) {
            world.func_147465_d(posX + xoffset, posY + y, posZ + zoffset, Blocks.field_150468_ap, meta, 3);
        }
        world.func_147465_d(posX + xoffset, posY + sizeY - 3, posZ + zoffset, Blocks.field_150396_be, (direction + 1) % 4, 3);
    }
}

