/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import team.chisel.init.ChiselBlocks;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MultiMBlock;
import techguns.worldgen.structures.Structure;

public class SmallTrainstation
extends Structure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public SmallTrainstation(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 1);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1);
    }

    static {
        blockList.add(new MBlock(Blocks.field_150351_n, 0));
        blockList.add(new MultiMBlock(new Block[]{Blocks.field_150448_aq, Blocks.field_150350_a}, new int[]{0, 0}, new int[]{2, 1}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.cobblestone, ChiselBlocks.mossy_cobblestone}, new int[]{2, 1}, new int[]{2, 1}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3]}, new int[]{8, 0}, new int[]{1, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS}, new boolean[]{true, true}));
        blockList.add(new MBlock((Block)ChiselBlocks.cobblestone, 10));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.brickCustom, ChiselBlocks.brickCustom}, new int[]{3, 5}, new int[]{2, 2}));
        blockList.add(new MBlock(TGBlocks.airMarker, 0));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.glass_pane, Blocks.field_150350_a}, new int[]{4, 0}, new int[]{1, 1}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3], Blocks.field_150350_a}, new int[]{13, 5, 0}, new int[]{2, 2, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS, BlockUtils.BlockType.TG}, new boolean[]{true, true, false}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestone, ChiselBlocks.limestone, Blocks.field_150350_a}, new int[]{1, 6, 0}, new int[]{2, 2, 1}));
        blockList.add(new MBlock(Blocks.field_150422_aJ, 0));
        blockList.add(new MBlock(Blocks.field_150452_aw, 0));
        blockList.add(new MBlock((Block)Blocks.field_150376_bx, 8));
        blockList.add(new MBlock(Blocks.field_150468_ap, 3, true, BlockUtils.BlockType.LADDER));
        blockList.add(new MBlock((Block)Blocks.field_150486_ae, 2, true, BlockUtils.BlockType.LADDER));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3], Blocks.field_150350_a}, new int[]{14, 6, 0}, new int[]{2, 2, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS, BlockUtils.BlockType.TG}, new boolean[]{true, true, false}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3], Blocks.field_150350_a}, new int[]{15, 7, 0}, new int[]{2, 2, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS, BlockUtils.BlockType.TG}, new boolean[]{true, true, false}));
        blockList.add(new MBlock(Blocks.field_150460_al, 4));
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3], Blocks.field_150350_a}, new int[]{12, 4, 0}, new int[]{2, 2, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS, BlockUtils.BlockType.TG}, new boolean[]{true, true, false}));
        blockList.add(new MultiMBlock(new Block[]{ChiselBlocks.limestoneStairs[0], ChiselBlocks.limestoneStairs[3], Blocks.field_150350_a}, new int[]{9, 1, 0}, new int[]{2, 2, 1}, new BlockUtils.BlockType[]{BlockUtils.BlockType.STAIRS2_CHISEL, BlockUtils.BlockType.STAIRS, BlockUtils.BlockType.TG}, new boolean[]{true, true, false}));
        blocks = BlockUtils.loadStructureFromFile("smallTrainstation");
    }
}

