/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import techguns.tileentities.MultiBlockMasterTileEntBase;

public abstract class MultiBlockSlaveTileEntBase
extends TileEntity {
    protected int masterX = 0;
    protected short masterY = 0;
    protected int masterZ = 0;
    protected boolean hasMaster = false;

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        boolean formed = this.hasMaster;
        this.hasMaster = tags.func_74767_n("hasMaster");
        if (this.hasMaster) {
            this.masterX = tags.func_74762_e("masterX");
            this.masterY = tags.func_74765_d("masterY");
            this.masterZ = tags.func_74762_e("masterZ");
        }
        if (formed != this.hasMaster) {
            this.causeRenderUpdate();
        }
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        tags.func_74757_a("hasMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("masterX", this.masterX);
            tags.func_74777_a("masterY", this.masterY);
            tags.func_74768_a("masterZ", this.masterZ);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_145841_b(tags);
        S35PacketUpdateTileEntity pkt = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tags);
        return pkt;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateMaster(int x, int y, int z) {
        this.masterX = x;
        this.masterY = (short)y;
        this.masterZ = z;
        this.hasMaster = true;
    }

    public void notifyMasterMultiblockBreak() {
        TileEntity ent;
        if (this.hasMaster && (ent = this.field_145850_b.func_147438_o(this.masterX, (int)this.masterY, this.masterZ)) != null && ent instanceof MultiBlockMasterTileEntBase) {
            MultiBlockMasterTileEntBase master = (MultiBlockMasterTileEntBase)ent;
            master.notifiyMultiblockBreak();
        }
    }

    public int[] getMasterPos() {
        if (this.hasMaster) {
            return new int[]{this.masterX, this.masterY, this.masterZ};
        }
        return null;
    }

    public boolean hasMaster() {
        return this.hasMaster;
    }

    public void unlink() {
        this.hasMaster = false;
        this.masterX = 0;
        this.masterY = 0;
        this.masterZ = 0;
    }

    public void needBlockUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void needUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    protected void causeRenderUpdate() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

