/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import techguns.entities.npc.AttackHelicopter;
import techguns.tileentities.BasicInventoryTileEnt;
import techguns.util.BlockUtils;
import techguns.util.NPCUtil;

public class CampFlagTileEnt
extends BasicInventoryTileEnt {
    static final int SPAWN_CHECK_INTERVAL = 40;
    static final int SPAWN_INTERVAL = 400;
    static final int SPAWN_AREA_RANGE = 4;
    static final int SIZE_Y = 20;
    public short xoffset;
    public short yoffset;
    public short zoffset;
    public short sizeX;
    public short sizeZ;
    public short maxNPCs;
    public short numSpawnPoints;
    public short spawnCheckTimer = (short)40;
    public short spawnTimer = (short)400;
    boolean canSpawn = false;
    public String[] npcSpawnList;
    public int[] spawnPositions;

    public CampFlagTileEnt() {
        super(0);
    }

    public void init(int sizeX, int sizeZ, int xoffset, int yoffset, int zoffset, int[] spawnPositions, String[] npcSpawnList) {
        this.sizeX = (short)sizeX;
        this.sizeZ = (short)sizeZ;
        this.xoffset = (short)xoffset;
        this.yoffset = (short)yoffset;
        this.zoffset = (short)zoffset;
        this.spawnPositions = spawnPositions;
        this.numSpawnPoints = (short)(spawnPositions.length / 3);
        this.npcSpawnList = npcSpawnList;
        this.maxNPCs = (short)((float)(sizeX + sizeZ) / 2.0f * 0.75f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            short s = this.spawnCheckTimer;
            this.spawnCheckTimer = (short)(s - 1);
            if (s <= 0) {
                this.spawnCheckTimer = (short)40;
                int count = this.countNPCs();
                if (count < this.maxNPCs) {
                    this.canSpawn = true;
                } else {
                    this.canSpawn = false;
                    this.spawnTimer = (short)400;
                }
            }
            if (this.canSpawn) {
                short s2 = this.spawnTimer;
                this.spawnTimer = (short)(s2 - 1);
                if (s2 <= 0) {
                    int spawnNum = this.field_145850_b.field_73012_v.nextInt(this.numSpawnPoints);
                    int spawnX = this.spawnPositions[spawnNum * 3 + 0];
                    int spawnY = this.spawnPositions[spawnNum * 3 + 1];
                    int spawnZ = this.spawnPositions[spawnNum * 3 + 2];
                    String npc = this.npcSpawnList[this.field_145850_b.field_73012_v.nextInt(this.npcSpawnList.length)];
                    NPCUtil.spawnEntity(this.field_145850_b, (double)(spawnX + (this.field_145851_c - this.xoffset)) + 0.5, spawnY + (this.field_145848_d - this.yoffset), (double)(spawnZ + (this.field_145849_e - this.zoffset)) + 0.5, npc);
                    this.spawnTimer = (short)400;
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 1));
    }

    private int countNPCs() {
        double posX = this.field_145851_c - this.xoffset;
        double posY = this.field_145848_d - this.yoffset;
        double posZ = this.field_145849_e - this.zoffset;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)this.sizeX, (double)20.0, (double)this.sizeZ).func_72314_b(8.0, 0.0, 8.0);
        NPCUtil.EntityByNameSelector filter = new NPCUtil.EntityByNameSelector(new ArrayList<String>(Arrays.asList(this.npcSpawnList)));
        List<Entity> entityList = BlockUtils.selectEntitiesWithinAABB(this.field_145850_b, bb, filter);
        return entityList.size();
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.sizeX = tags.func_74765_d("sizeX");
        this.sizeZ = tags.func_74765_d("sizeZ");
        this.xoffset = tags.func_74765_d("xoffset");
        this.yoffset = tags.func_74765_d("yoffset");
        this.zoffset = tags.func_74765_d("zoffset");
        this.spawnPositions = tags.func_74759_k("spawnPositions");
        this.numSpawnPoints = this.spawnPositions != null ? (short)(this.spawnPositions.length / 3) : (short)0;
        this.maxNPCs = (short)((float)(this.sizeX + this.sizeZ) / 2.0f * 0.75f);
        short npcListSize = tags.func_74765_d("npcListSize");
        this.npcSpawnList = new String[npcListSize];
        for (int i = 0; i < this.npcSpawnList.length; ++i) {
            this.npcSpawnList[i] = tags.func_74779_i("npcName" + i);
        }
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74777_a("sizeX", this.sizeX);
        tags.func_74777_a("sizeZ", this.sizeZ);
        tags.func_74777_a("xoffset", this.xoffset);
        tags.func_74777_a("yoffset", this.yoffset);
        tags.func_74777_a("zoffset", this.zoffset);
        tags.func_74783_a("spawnPositions", this.spawnPositions);
        if (this.npcSpawnList != null) {
            tags.func_74777_a("npcListSize", (short)this.npcSpawnList.length);
            for (int i = 0; i < this.npcSpawnList.length; ++i) {
                tags.func_74778_a("npcName" + i, this.npcSpawnList[i]);
            }
        }
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public String func_145825_b() {
        return "container.campflag";
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Override
    public void onBlockBreak() {
        super.onBlockBreak();
        this.onDestroyed();
    }

    protected void onDestroyed() {
        if (!this.field_145850_b.field_72995_K) {
            AttackHelicopter heli = new AttackHelicopter(this.field_145850_b);
            heli.func_70107_b(this.field_145851_c, this.field_145848_d + 50, this.field_145849_e);
            this.field_145850_b.func_72838_d((Entity)heli);
        }
    }
}

