/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import techguns.tileentities.BasicPoweredTileEnt;

public abstract class BasicMachineTileEntity
extends BasicPoweredTileEnt {
    public ItemStack currentOperation = null;
    public int totalTime = 0;
    public int progress = 0;
    public int stackmultiplier = 1;

    public BasicMachineTileEntity(int slotCount, int MaximumPower) {
        super(slotCount, MaximumPower);
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tags) {
        super.readEntityDataFromNBT(tags);
        this.progress = tags.func_74765_d("Progress");
        this.totalTime = tags.func_74765_d("TotalTime");
        this.stackmultiplier = tags.func_74771_c("StackMultiplier");
        NBTTagCompound currentOp = tags.func_74775_l("CurrentOperation");
        this.currentOperation = currentOp.func_82582_d() ? null : ItemStack.func_77949_a((NBTTagCompound)currentOp);
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tags) {
        super.writeEntityDataToNBT(tags);
        tags.func_74777_a("Progress", (short)this.progress);
        tags.func_74777_a("TotalTime", (short)this.totalTime);
        tags.func_74774_a("StackMultiplier", (byte)this.stackmultiplier);
        if (this.currentOperation != null) {
            NBTTagCompound currentOp = new NBTTagCompound();
            this.currentOperation.func_77955_b(currentOp);
            tags.func_74782_a("CurrentOperation", (NBTBase)currentOp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int limit) {
        if (this.totalTime != 0) {
            return this.progress * limit / this.totalTime;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPowerScaled(int limit) {
        if (this.totalTime != 0) {
            return this.energy.getMaxEnergyStored() * limit / this.energy.getMaxEnergyStored();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgress() {
        if (this.totalTime > 0) {
            return (float)this.progress / (float)this.totalTime;
        }
        return 0.0f;
    }

    public boolean isWorking() {
        return this.currentOperation != null;
    }
}

