/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;
import techguns.items.GenericItem;
import techguns.items.TGSlotType;
import techguns.items.armors.ICamoChangeable;
import techguns.items.armors.ITGSpecialSlot;
import techguns.util.TextUtil;

public abstract class ItemTGSpecialSlot
extends GenericItem
implements ITGSpecialSlot,
ICamoChangeable {
    protected String textureName;
    protected byte camoCount;

    public ItemTGSpecialSlot(String unlocalizedName, String textureName, int camoCount, int dur) {
        super(unlocalizedName);
        this.textureName = textureName;
        this.func_111206_d("Techguns:" + unlocalizedName);
        this.field_77777_bU = 1;
        this.func_77656_e(dur);
        this.camoCount = (byte)camoCount;
    }

    @Override
    public int getCamoCount() {
        return this.camoCount;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID > 0) {
            return TextUtil.trans(this.func_77658_a() + ".camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.defaultcamo");
    }

    @Override
    public int getCurrentCamoIndex(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        return camoID;
    }

    @Override
    public int switchCamo(ItemStack item) {
        return this.switchCamo(item, false);
    }

    @Override
    public int switchCamo(ItemStack item, boolean back) {
        byte camoID = 0;
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (tags == null) {
            tags = new NBTTagCompound();
            tags.func_74774_a("camo", (byte)0);
            item.func_77982_d(tags);
        }
        if (this.camoCount > 1) {
            camoID = !back ? (byte)(camoID + 1) : (byte)(camoID - 1);
            if (camoID >= this.camoCount) {
                camoID = 0;
            } else if (camoID < 0) {
                camoID = (byte)(this.camoCount - 1);
            }
            tags.func_74774_a("camo", camoID);
            return camoID;
        }
        return 0;
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        list.add(EnumChatFormatting.GRAY + "Slot: " + (Object)((Object)this.getSlot(item)));
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        if (this.getSlot(stack) == TGSlotType.BACKSLOT) {
            TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(player);
            if (props.TG_inventory.inventory[1] == null) {
                props.TG_inventory.inventory[1] = stack.func_77946_l();
                stack.field_77994_a = 0;
                return stack;
            }
        } else if (this.getSlot(stack) == TGSlotType.FACESLOT) {
            TechgunsExtendedPlayerProperties props = TechgunsExtendedPlayerProperties.get(player);
            if (props.TG_inventory.inventory[0] == null) {
                props.TG_inventory.inventory[0] = stack.func_77946_l();
                stack.field_77994_a = 0;
                return stack;
            }
        }
        return super.func_77659_a(stack, w, player);
    }
}

