/*
 * Decompiled with CFR 0.152.
 */
package techguns.items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import techguns.TGBlocks;
import techguns.Techguns;
import techguns.items.GenericItem;
import techguns.util.TextUtil;

public class OreClusterScanner
extends GenericItem
implements IEnergyContainerItem {
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;
    private static final int RF_PER_USETICK = 300;
    private static final int MAXRF = 30000;
    private static final int SCANDURATION = 40;

    public OreClusterScanner() {
        super("oreClusterScanner");
        this.func_77625_d(1);
        this.capacity = 30000;
        this.maxReceive = 3000;
        this.maxExtract = 3000;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack stack = new ItemStack(item);
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", 30000);
        list.add(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(this.getEnergyStored(stack) + "/" + this.capacity + " RF");
    }

    public void func_77615_a(ItemStack item, World world, EntityPlayer player, int count) {
        int dur = this.func_77626_a(item) - count;
        int extracted = this.extractEnergy(item, 300, false);
        if (world.field_72995_K && extracted == 300 && dur >= 40) {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            int startY = y + 16;
            if (startY > world.func_72800_K()) {
                startY = world.func_72800_K();
            }
            Chunk c = world.func_72938_d(x, z);
            int x0 = c.field_76635_g * 16;
            int z0 = c.field_76647_h * 16;
            ArrayList<String> foundTypes = new ArrayList<String>();
            boolean found = false;
            for (int iy = startY; iy > 0; --iy) {
                for (int ix = 0; ix < 16; ++ix) {
                    for (int iz = 0; iz < 16; ++iz) {
                        Block b = c.func_150810_a(ix, iy, iz);
                        if (!TGBlocks.isOrecluster(b)) continue;
                        int clusterMeta = c.func_76628_c(ix, iy, iz);
                        String name = TextUtil.trans(b.func_149739_a() + "_" + clusterMeta + ".name");
                        if (!foundTypes.contains(name)) {
                            foundTypes.add(name);
                        }
                        Techguns.proxy.createFX("OreClusterPing", world, (double)(x0 + ix) + 0.5, (double)iy + 0.5, (double)(z0 + iz) + 0.5, 0.0, 0.0, 0.0);
                        found = true;
                    }
                }
            }
            if (found) {
                player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.OreClusterScanner.msg.found")));
                for (int i = 0; i < foundTypes.size(); ++i) {
                    player.func_145747_a((IChatComponent)new ChatComponentText((String)foundTypes.get(i)));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.OreClusterScanner.msg.notFound")));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int dur = this.func_77626_a(stack) - count;
        if (dur >= 40) {
            player.func_71034_by();
        }
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) * 1.0 / ((double)this.capacity * 1.0);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", 30000);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        player.func_71008_a(item, this.func_77626_a(item));
        return item;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

