/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import techguns.inventory.ItemStackOreDict;
import techguns.util.ItemUtil;

public class ChemLabRecipes {
    public static final byte CHEM_LAB_NO_FLUID = 0;
    public static final byte CHEM_LAB_FLUID_WATER = 1;
    public static final byte CHEM_LAB_FLUID_LAVA = 2;
    public static final byte CHEM_LAB_FLUID_OIL = 3;
    public static final byte CHEM_LAB_FLUID_FUEL = 4;
    private static ArrayList<ChemLabRecipe> recipes = new ArrayList();

    public static ChemLabOutput getOutputFor(ItemStack slot1, ItemStack slot2, ItemStack slot3, FluidStack fluidIn) {
        for (int i = 0; i < recipes.size(); ++i) {
            ChemLabRecipe recipe = recipes.get(i);
            if (!recipe.isValidInput(slot1, slot2, slot3, fluidIn)) continue;
            return new ChemLabOutput(recipe.output, recipe.fluidOutput, recipe.amounts[0], recipe.amounts[1], recipe.amounts[2], recipe.amounts[3], recipe.powerPerTick);
        }
        return null;
    }

    public static ArrayList<ChemLabRecipe> getRecipes() {
        return recipes;
    }

    public static int getTotalPower(int recipeIndex) {
        return ChemLabRecipes.recipes.get((int)recipeIndex).powerPerTick * 100;
    }

    public static ChemLabRecipe getRecipe(int index) {
        return recipes.get(index);
    }

    public static ArrayList<ChemLabRecipe> getRecipesUsing(ItemStack input) {
        ArrayList<ChemLabRecipe> ret = new ArrayList<ChemLabRecipe>();
        for (ChemLabRecipe r : recipes) {
            if (!r.isItemPartOfRecipe(input)) continue;
            ret.add(r);
        }
        return ret;
    }

    public static ChemLabRecipe getRecipesFor(ItemStack output) {
        for (ChemLabRecipe r : recipes) {
            if (!ItemUtil.isItemEqual(r.output, output)) continue;
            return r;
        }
        return null;
    }

    public static boolean allowInFlaskSlot(ItemStack item) {
        return item != null && item.func_77973_b() == Items.field_151069_bo;
    }

    public static boolean hasRecipeUsing(ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).isItemPartOfRecipe(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowAsInput2(ItemStack slot1, ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).isValidInputSlot1_2(slot1, item)) continue;
            return true;
        }
        return false;
    }

    public static void addRecipe(ItemStack input1, int amount1, ItemStack input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(String input1, int amount1, String input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(String input1, int amount1, ItemStack input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(ItemStack input1, int amount1, String input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static void addRecipe(ItemStackOreDict input1, int amount1, ItemStackOreDict input2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, FluidStack fluidOut, ItemStack output, boolean swap, int power) {
        recipes.add(new ChemLabRecipe(input1, amount1, input2, amount2, bottle, amount3, fluidIn, swap, output, fluidOut, power));
    }

    public static class ChemLabRecipe {
        public ItemStackOreDict slot1;
        public ItemStackOreDict slot2;
        public ItemStack slot3;
        public FluidStack fluidIn;
        public FluidStack fluidOutput;
        public boolean allowSwap;
        public ItemStack output;
        public int[] amounts = new int[4];
        public int powerPerTick = 5;

        public boolean isItemPartOfRecipe(ItemStack item) {
            return this.slot1 != null && this.slot1.isEqualWithOreDict(item) || this.slot2 != null && this.slot2.isEqualWithOreDict(item) || this.slot3 != null && ItemUtil.isItemEqual(this.slot3, item);
        }

        public ChemLabRecipe(ItemStackOreDict slot1, int amount1, ItemStackOreDict slot2, int amount2, ItemStack bottle, int amount3, FluidStack fluidIn, boolean allowSwap, ItemStack output, FluidStack fluidOutput, int powerPerTick) {
            this.slot1 = slot1;
            this.slot2 = slot2;
            this.slot3 = bottle;
            this.fluidIn = fluidIn;
            this.fluidOutput = fluidOutput;
            this.allowSwap = allowSwap;
            this.output = output;
            this.amounts[0] = amount1;
            this.amounts[1] = amount2;
            this.amounts[2] = amount3;
            this.amounts[3] = fluidIn != null ? fluidIn.amount : 0;
            this.powerPerTick = powerPerTick;
        }

        public boolean isValidInput(ItemStack slot1, ItemStack slot2, ItemStack slot3, FluidStack fluidIn) {
            if (this.slot1.isEqualWithOreDict(slot1) && this.slot2.isEqualWithOreDict(slot2) && (this.slot3 != null && OreDictionary.itemMatches((ItemStack)this.slot3, (ItemStack)slot3, (boolean)true) || this.slot3 == null && slot3 == null)) {
                return this.checkLiquid(fluidIn);
            }
            if (this.allowSwap && this.slot1.isEqualWithOreDict(slot2) && this.slot2.isEqualWithOreDict(slot1) && (this.slot3 != null && OreDictionary.itemMatches((ItemStack)this.slot3, (ItemStack)slot3, (boolean)true) || this.slot3 == null && slot3 == null)) {
                return this.checkLiquid(fluidIn);
            }
            return false;
        }

        public boolean isValidInputSlot1_2(ItemStack slot1, ItemStack slot2) {
            if (this.slot1.isEqualWithOreDict(slot1) && this.slot2.isEqualWithOreDict(slot2)) {
                return true;
            }
            return this.allowSwap && this.slot1.isEqualWithOreDict(slot2) && this.slot2.isEqualWithOreDict(slot1);
        }

        private boolean checkLiquid(FluidStack fluid) {
            if (this.fluidIn == null) {
                return true;
            }
            if (fluid == null) {
                return false;
            }
            if (this.fluidIn.getFluid() == fluid.getFluid()) {
                return this.fluidIn.amount <= fluid.amount;
            }
            return false;
        }
    }

    public static class ChemLabOutput {
        private ItemStack output;
        private FluidStack liquidOutput;
        private int[] consumption;
        private int powerPerTick;

        public ChemLabOutput(ItemStack output, FluidStack liquidOutput, int i1, int i2, int i3, int i4, int power) {
            this.output = output;
            this.liquidOutput = liquidOutput;
            this.consumption = new int[4];
            this.consumption[0] = i1;
            this.consumption[1] = i2;
            this.consumption[2] = i3;
            this.consumption[3] = i4;
            this.powerPerTick = power;
        }

        public ChemLabOutput(NBTTagCompound tags) {
            this(null, null, 0, 0, 0, 0, 0);
            this.loadFromNBTTags(tags);
        }

        public ItemStack getItemOutput() {
            return this.output;
        }

        public FluidStack getLiquidOutput() {
            return this.liquidOutput;
        }

        public int getAmount(int i) {
            return this.consumption[i];
        }

        public int getPowerPerTick() {
            return this.powerPerTick;
        }

        public void loadFromNBTTags(NBTTagCompound tags) {
            NBTTagCompound item = tags.func_74775_l("output");
            this.output = !item.func_82582_d() ? ItemStack.func_77949_a((NBTTagCompound)item) : null;
            NBTTagCompound fluid = tags.func_74775_l("liquidOutput");
            this.liquidOutput = !fluid.func_82582_d() ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid) : null;
            this.powerPerTick = tags.func_74762_e("powerPerTick");
        }

        public NBTTagCompound getAsNBTTags() {
            NBTTagCompound tags = new NBTTagCompound();
            if (this.output != null) {
                NBTTagCompound outputItem = new NBTTagCompound();
                this.output.func_77955_b(outputItem);
                tags.func_74782_a("output", (NBTBase)outputItem);
            }
            if (this.liquidOutput != null) {
                NBTTagCompound liquidOutput = new NBTTagCompound();
                this.liquidOutput.writeToNBT(liquidOutput);
                tags.func_74782_a("liquidOutput", (NBTBase)liquidOutput);
            }
            tags.func_74768_a("powerPerTick", this.powerPerTick);
            return tags;
        }
    }
}

