/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import techguns.client.renderer.TGRenderHelper;
import techguns.entities.projectiles.MovingBeam;
import techguns.util.MathUtil;

public class RenderMovingBeam
extends Render {
    private static final ResourceLocation LaserTextures = new ResourceLocation("techguns:textures/fx/nukebeam.png");
    private double laserWidth = 3.0;
    private int maxTicks = 10;

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float ptt) {
        MovingBeam laser = (MovingBeam)par1Entity;
        Random rand = new Random(par1Entity.func_145782_y());
        double distance = laser.beamlength;
        float prog = ((float)par1Entity.field_70173_aa + ptt) / (float)this.maxTicks;
        double width = this.laserWidth * Math.sin(Math.sqrt(prog) * Math.PI) * 2.0;
        this.func_110777_b(par1Entity);
        GL11.glPushAttrib((int)8192);
        TGRenderHelper.enableFXLighting();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        this.func_110777_b(par1Entity);
        EntityLivingBase shooter = (EntityLivingBase)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(laser.shooterID);
        if (shooter != null) {
            double x = shooter.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70165_t;
            double y = shooter.field_70163_u + (double)shooter.func_70047_e() - (Minecraft.func_71410_x().field_71439_g.field_70163_u + (double)Minecraft.func_71410_x().field_71439_g.func_70047_e());
            double z = shooter.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70161_v;
            float pitch = MathUtil.interpolateRotation(shooter.field_70127_C, shooter.field_70125_A, ptt);
            float yaw = MathUtil.interpolateRotation(shooter.field_70758_at, shooter.field_70759_as, ptt);
            if (shooter == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                Vec3 offset = Vec3.func_72443_a((double)0.0, (double)-0.08, (double)0.12);
                MathUtil.rotateAroundZ(offset, (double)pitch * (Math.PI / 180));
                MathUtil.rotateAroundY(offset, (-90.0 - (double)yaw) * (Math.PI / 180));
                x += offset.field_72450_a;
                y += offset.field_72448_b;
                z += offset.field_72449_c;
            } else {
                x -= (double)(MathHelper.func_76134_b((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
                y -= (double)-0.1f;
                z -= (double)(MathHelper.func_76126_a((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            }
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glRotatef((float)(-(yaw - 90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            if (shooter == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && Minecraft.func_71410_x().field_71474_y.field_74336_f) {
                this.setupViewBobbing(ptt);
            }
            GL11.glTranslated((double)-0.25, (double)0.0, (double)0.0);
            distance += 0.25;
            Tessellator tessellator = Tessellator.field_78398_a;
            float f10 = 0.0125f;
            distance *= 80.0;
            GL11.glEnable((int)32826);
            GL11.glDisable((int)2884);
            float rot_x = 45.0f + prog * 360.0f;
            GL11.glRotatef((float)(rot_x + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)f10, (float)f10, (float)f10);
            float brightness = (float)Math.sin(Math.sqrt(prog) * Math.PI);
            double UVscale = 2.0;
            int numFrames = 17;
            float frametime = 0.5f;
            double u = distance / (this.laserWidth * 8.0 * UVscale);
            int frame = (int)(((float)par1Entity.field_70173_aa + ptt) * frametime % (float)numFrames);
            double v1 = 1.0 / (double)numFrames * (double)frame;
            double v2 = 1.0 / (double)numFrames * (double)(frame + 1);
            for (int i = 0; i < 2; ++i) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)f10);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, brightness);
                tessellator.func_78382_b();
                tessellator.func_78374_a(-distance, -width, 0.0, (double)(0 + i), v1);
                tessellator.func_78374_a(0.0, -width, 0.0, u + (double)i, v1);
                tessellator.func_78374_a(0.0, width, 0.0, u + (double)i, v2);
                tessellator.func_78374_a(-distance, width, 0.0, (double)(0 + i), v2);
                tessellator.func_78381_a();
            }
            distance = Math.min(distance, 400.0);
            int segments = (int)(distance / 8.0);
            double w = 4.0;
            double radius = 0.0;
            double angle = 0.39269908169872414;
            double prevX = 0.0;
            double prevY = 0.0;
            double prevZ = 0.0;
            double prevu = 0.0;
            double cos2 = Math.cos((Math.PI - angle) * 0.5) * 2.0;
            double angleOffset = rand.nextDouble() * Math.PI * 2.0;
            UVscale = 8.0;
            double d = distance / (double)segments;
            for (int i = 0; i < segments; ++i) {
                x = -d * (double)i;
                float iprog = (float)i / (float)segments;
                radius = 0.5 * (1.0 - Math.cos(2.0 * Math.sqrt(iprog) * Math.PI)) * 8.0;
                MathUtil.Vec2 yz = MathUtil.polarOffsetXZ(0.0, 0.0, radius, angleOffset - angle * (double)i);
                y = yz.x;
                z = yz.y;
                u = prevu + cos2 * radius / UVscale;
                tessellator.func_78382_b();
                tessellator.func_78374_a(prevX - w, prevY, prevZ, prevu, v2);
                tessellator.func_78374_a(x - w, y, z, u, v2);
                tessellator.func_78374_a(x + w, y, z, u, v1);
                tessellator.func_78374_a(prevX + w, prevY, prevZ, prevu, v1);
                tessellator.func_78381_a();
                prevX = x;
                prevY = y;
                prevZ = z;
                prevu = u;
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        TGRenderHelper.disableFXLighting();
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return LaserTextures;
    }

    private void setupViewBobbing(float p_78475_1_) {
        if (Minecraft.func_71410_x().field_71451_h instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)Minecraft.func_71410_x().field_71451_h;
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * p_78475_1_);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * p_78475_1_;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * p_78475_1_;
            float F1 = -1.0f;
            float F2 = -1.0f;
            GL11.glTranslatef((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f * F1), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3) * F2), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }
}

