/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import techguns.client.models.ModelNull;
import techguns.client.renderer.TGRenderHelper;
import techguns.entities.npc.AttackHelicopter;

@SideOnly(value=Side.CLIENT)
public class RenderHelicopter
extends RendererLivingEntity {
    private ResourceLocation texture;
    private IModelCustom model;

    public RenderHelicopter(String model, String texture) {
        super((ModelBase)new ModelNull(), 5.0f);
        this.texture = new ResourceLocation("techguns", texture);
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("techguns", model));
    }

    public void doRender(AttackHelicopter entity, double x, double y, double z, float par8, float partialTickTime) {
        float yaw = TGRenderHelper.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTickTime);
        float yawHead = TGRenderHelper.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTickTime);
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTickTime;
        BossStatus.func_82824_a((IBossDisplayData)entity, (boolean)true);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)0.0, (double)0.0, (double)1.0);
        this.func_110776_a(this.texture);
        if (entity.field_70725_aQ == 0) {
            this.model.renderAllExcept(new String[]{"ROTOR", "GUN"});
            GL11.glPushMatrix();
            GL11.glTranslatef((float)16.0f, (float)-1.0f, (float)0.0f);
            GL11.glRotatef((float)(-yaw + yawHead), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-16.0f, (float)1.0f, (float)0.0f);
            this.model.renderOnly(new String[]{"GUN"});
            GL11.glPopMatrix();
            double angle = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) + partialTickTime) * 24.0f;
            GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
            this.model.renderOnly(new String[]{"ROTOR"});
        } else {
            float deathProgress = ((float)entity.field_70725_aQ + partialTickTime) / (float)entity.maxDeathTime;
            float p = (float)Math.pow(deathProgress, 2.0);
            GL11.glTranslatef((float)0.0f, (float)(p * -40.0f), (float)0.0f);
            float angle = p * 720.0f;
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.renderAllExcept(new String[]{"ROTOR"});
            angle = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) + partialTickTime) * 12.0f;
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.renderOnly(new String[]{"ROTOR"});
        }
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity e) {
        return this.texture;
    }

    protected void func_77041_b(EntityLivingBase p_77041_1_, float p_77041_2_) {
    }

    public void func_76986_a(Entity e, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((AttackHelicopter)e, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

