/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.ctm;

import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import techguns.blocks.ctm.CarvingVariation;

public class CarvingRegistry
implements ICarvingRegistry {
    ArrayList<ICarvingGroup> carvingGroups = new ArrayList();

    public ICarvingGroup getGroup(Block block, int meta) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != meta) continue;
                return group;
            }
        }
        return null;
    }

    public ICarvingGroup getGroup(String name) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public ICarvingVariation getVariation(Block block, int meta) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != meta) continue;
                return var;
            }
        }
        return null;
    }

    public List<ICarvingVariation> getGroupVariations(Block block, int meta) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != meta) continue;
                return variations;
            }
        }
        return null;
    }

    public String getOreName(Block block, int meta) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != meta) continue;
                return group.getOreName();
            }
        }
        return null;
    }

    public List<ItemStack> getItemsForChiseling(ItemStack chiseled) {
        ICarvingGroup group = this.getGroup(Block.func_149634_a((Item)chiseled.func_77973_b()), chiseled.func_77960_j());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < group.getVariations().size(); ++i) {
            ICarvingVariation var = (ICarvingVariation)group.getVariations().get(i);
            items.add(new ItemStack(var.getBlock(), chiseled.field_77994_a, var.getItemMeta()));
        }
        return items;
    }

    public String getVariationSound(Block block, int meta) {
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != meta) continue;
                return group.getSound();
            }
        }
        return null;
    }

    public String getVariationSound(Item item, int meta) {
        return this.getVariationSound(Block.func_149634_a((Item)item), meta);
    }

    public List<String> getSortedGroupNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            names.add(group.getName());
        }
        Collections.sort(names);
        return names;
    }

    public void addVariation(String groupName, Block block, int metadata, int order) {
        ICarvingGroup group = this.getGroup(groupName);
        group.addVariation((ICarvingVariation)new CarvingVariation(block, metadata, metadata, order));
    }

    public void addVariation(String groupName, ICarvingVariation variation) {
        ICarvingGroup group = this.getGroup(groupName);
        group.addVariation(variation);
    }

    public void addGroup(ICarvingGroup group) {
        this.carvingGroups.add(group);
    }

    public ICarvingGroup removeGroup(String groupName) {
        ICarvingGroup group = this.getGroup(groupName);
        this.carvingGroups.remove(group);
        return group;
    }

    public ICarvingVariation removeVariation(Block block, int metadata) {
        ICarvingVariation lastRemoved = null;
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != metadata) continue;
                group.removeVariation(var);
                lastRemoved = var;
            }
        }
        return lastRemoved;
    }

    public ICarvingVariation removeVariation(Block block, int metadata, String groupName) {
        ICarvingVariation lastRemoved = null;
        for (int i = 0; i < this.carvingGroups.size(); ++i) {
            ICarvingGroup group = this.carvingGroups.get(i);
            if (!group.getName().equals(groupName)) continue;
            List variations = group.getVariations();
            for (int j = 0; j < variations.size(); ++j) {
                ICarvingVariation var = (ICarvingVariation)variations.get(j);
                if (var.getBlock() != block || var.getBlockMeta() != metadata) continue;
                group.removeVariation(var);
                lastRemoved = var;
            }
        }
        return lastRemoved;
    }

    public void registerOre(String groupName, String oreName) {
        ICarvingGroup group = this.getGroup(groupName);
        group.setOreName(oreName);
    }

    public void setVariationSound(String groupName, String sound) {
        ICarvingGroup group = this.getGroup(groupName);
        group.setSound(sound);
    }
}

