/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.items;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.items.ItemEMCBook;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCell;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCellCreative;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystalOld;
import com.mordenkainen.equivalentenergistics.items.ItemMisc;
import com.mordenkainen.equivalentenergistics.items.ItemPattern;
import com.mordenkainen.equivalentenergistics.items.ItemStorageComponent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;

public enum ItemEnum {
    EMCBOOK("EMCBook", (Item)new ItemEMCBook(), Integration.Mods.PROJECTE.getTest()),
    EMCPATTERN("EMCPattern", (Item)new ItemPattern(), true),
    EMCCRYSTAL("EMCStorageItem", new ItemEMCCrystal()),
    EMCCRYSTALOLD("EMCCrystal", new ItemEMCCrystalOld()),
    EMCCELL("EMCCell", new ItemEMCCell()),
    EMCCELLCREATIVE("EMCCellCreative", new ItemEMCCellCreative()),
    MISCITEM("ItemMisc", new ItemMisc()),
    CELLCOMPONENT("EMCStorageComponent", new ItemStorageComponent());

    private final String internalName;
    private Item item;
    private Predicate<?> requirements;
    private boolean enabled = true;
    private boolean hidden;
    private String configKey;

    private ItemEnum(String internalName, Item item) {
        this(internalName, item, null, false, Predicates.alwaysTrue());
    }

    private ItemEnum(String internalName, Item item, String configKey) {
        this(internalName, item, configKey, false, Predicates.alwaysTrue());
    }

    private ItemEnum(String internalName, Item item, boolean hidden) {
        this(internalName, item, null, hidden, Predicates.alwaysTrue());
    }

    private ItemEnum(String internalName, Item item, Predicate<?> requirements) {
        this(internalName, item, null, false, requirements);
    }

    private ItemEnum(String internalName, Item item, String configKey, Predicate<?> requirements) {
        this(internalName, item, configKey, false, requirements);
    }

    private ItemEnum(String internalName, Item item, boolean hidden, Predicate<?> requirements) {
        this(internalName, item, null, hidden, requirements);
    }

    private ItemEnum(String internalName, Item item, String configKey, boolean hidden) {
        this(internalName, item, configKey, hidden, Predicates.alwaysTrue());
    }

    private ItemEnum(String internalName, Item item, String configKey, boolean hidden, Predicate<?> requirements) {
        this.internalName = internalName;
        this.item = item;
        this.item.func_77655_b("equivalentenergistics:" + internalName);
        this.configKey = configKey;
        this.hidden = hidden;
        this.requirements = requirements;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getSizedStack(int size) {
        return new ItemStack(this.item, size);
    }

    public ItemStack getDamagedStack(int damage) {
        return new ItemStack(this.item, 1, damage);
    }

    public ItemStack getFullStack() {
        return new ItemStack(this.item, 64);
    }

    public ItemStack getStack(int size, int damage) {
        return new ItemStack(this.item, size, damage);
    }

    public String getStatName() {
        return StatCollector.func_74838_a((String)this.item.func_77658_a());
    }

    public Predicate<?> getReqs() {
        return this.requirements;
    }

    public boolean isEnabled() {
        return this.enabled && this.requirements.apply(null);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSameItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        return stack.func_77973_b() == this.item;
    }

    public static void loadConfig(Configuration config) {
        for (ItemEnum current : ItemEnum.values()) {
            if (current.configKey != null) {
                current.enabled = config.get("Items", current.configKey, true).getBoolean(true);
            }
            if (current.item instanceof IConfigurable) {
                ((IConfigurable)current.item).loadConfig(config);
            }
            if (!current.isEnabled() || current.isHidden()) continue;
            current.item.func_77637_a(EquivalentEnergistics.tabEE);
        }
    }

    public static void registerItems() {
        for (ItemEnum current : ItemEnum.values()) {
            if (!current.isEnabled()) continue;
            GameRegistry.registerItem((Item)current.getItem(), (String)current.getInternalName());
        }
    }

    public static boolean isCrystal(ItemStack stack) {
        return EMCCRYSTAL.isSameItem(stack) || EMCCRYSTALOLD.isSameItem(stack);
    }
}

