/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.projecte;

import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafterBase;
import com.mordenkainen.equivalentenergistics.integration.IEMCHandler;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.EMCCraftingGrid;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystalOld;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.api.item.IItemEmc;
import net.minecraft.item.ItemStack;

public class ProjectE
implements IEMCHandler {
    @Override
    public boolean hasEMC(ItemStack itemStack) {
        return ProjectEAPI.getEMCProxy().getValue(itemStack) > 0;
    }

    @Override
    public double getEnergyValue(ItemStack itemStack) {
        return ProjectEAPI.getEMCProxy().getValue(itemStack);
    }

    @Override
    public double getCrystalEMC(int tier) {
        return ItemEMCCrystal.CRYSTAL_VALUES[tier];
    }

    @Override
    public List<ItemStack> getTransmutations(TileEMCCrafterBase tile) {
        ArrayList<ItemStack> transmutations = ProjectEAPI.getTransmutationProxy().getKnowledge(UUID.fromString(tile.getCurrentTome().func_77978_p().func_74779_i("OwnerUUID")));
        if (transmutations == null) {
            transmutations = new ArrayList<ItemStack>();
        }
        Iterator iter = transmutations.iterator();
        while (iter.hasNext()) {
            ItemStack currentItem = (ItemStack)iter.next();
            if (currentItem != null && !ItemEnum.isCrystal(currentItem)) continue;
            iter.remove();
        }
        return transmutations;
    }

    @Override
    public boolean isValidTome(ItemStack itemStack) {
        return itemStack != null && ItemEnum.EMCBOOK.isSameItem(itemStack) && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("OwnerUUID");
    }

    @Override
    public void setCrystalEMC() {
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTAL.getItem(), 1, 0), (int)ItemEMCCrystal.CRYSTAL_VALUES[0]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTAL.getItem(), 1, 1), (int)ItemEMCCrystal.CRYSTAL_VALUES[1]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTAL.getItem(), 1, 2), (int)ItemEMCCrystal.CRYSTAL_VALUES[2]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTAL.getItem(), 1, 3), (int)ItemEMCCrystal.CRYSTAL_VALUES[3]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTAL.getItem(), 1, 4), (int)ItemEMCCrystal.CRYSTAL_VALUES[4]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTALOLD.getItem(), 1, 0), (int)ItemEMCCrystalOld.CRYSTAL_VALUES[0]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTALOLD.getItem(), 1, 1), (int)ItemEMCCrystalOld.CRYSTAL_VALUES[1]);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(ItemEnum.EMCCRYSTALOLD.getItem(), 1, 2), (int)ItemEMCCrystalOld.CRYSTAL_VALUES[2]);
    }

    @Override
    public UUID getTomeUUID(ItemStack currentTome) {
        return UUID.fromString(currentTome.func_77978_p().func_74779_i("OwnerUUID"));
    }

    @Override
    public String getTomeOwner(ItemStack currentTome) {
        return currentTome.func_77978_p().func_74779_i("Owner");
    }

    @Override
    public double getSingleEnergyValue(ItemStack stack) {
        ItemStack singleStack = stack.func_77946_l();
        singleStack.field_77994_a = 1;
        return this.getEnergyValue(singleStack);
    }

    @SubscribeEvent
    public void onPlayerKnowledgeChange(PlayerKnowledgeChangeEvent event) {
        EMCCraftingGrid.knowledgeEvent(event.playerUUID);
    }

    @SubscribeEvent
    public void onEnergyValueChange(EMCRemapEvent event) {
        EMCCraftingGrid.energyEvent();
    }

    @Override
    public boolean isEMCStorage(ItemStack stack) {
        return stack.func_77973_b() instanceof IItemEmc;
    }

    @Override
    public double getStoredEMC(ItemStack stack) {
        return stack.func_77973_b() instanceof IItemEmc ? ((IItemEmc)stack.func_77973_b()).getStoredEmc(stack) : 0.0;
    }

    @Override
    public double extractEMC(ItemStack stack, double toStore) {
        return stack.func_77973_b() instanceof IItemEmc ? ((IItemEmc)stack.func_77973_b()).extractEmc(stack, toStore) : 0.0;
    }
}

