/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.core.crafting;

import com.mordenkainen.equivalentenergistics.blocks.BlockEnum;
import com.mordenkainen.equivalentenergistics.core.config.ConfigManager;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class CraftingManager {
    private static final int NUM_CELLS = 8;
    public static Item aeMaterial;
    private static ItemStack base;
    private static Item aeGlass;
    private static ItemStack dust;
    private static String quartzCrystals;

    private CraftingManager() {
    }

    public static void initRecipes() {
        aeMaterial = GameRegistry.findItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial");
        base = new ItemStack(GameRegistry.findItem((String)"appliedenergistics2", (String)"tile.BlockSkyStone"), 1, 1);
        aeGlass = GameRegistry.findItem((String)"appliedenergistics2", (String)"tile.BlockQuartzGlass");
        dust = ConfigManager.useEE3 ? new ItemStack(GameRegistry.findItem((String)"EE3", (String)"alchemicalDust"), 1, 3) : new ItemStack(GameRegistry.findItem((String)"ProjectE", (String)"item.pe_covalence_dust"), 1, 2);
        OreDictionary.registerOre((String)quartzCrystals, (ItemStack)new ItemStack(aeMaterial, 1, 0));
        OreDictionary.registerOre((String)quartzCrystals, (ItemStack)new ItemStack(aeMaterial, 1, 1));
        OreDictionary.registerOre((String)quartzCrystals, (ItemStack)new ItemStack(aeMaterial, 1, 10));
        if (BlockEnum.EMCCONDENSER.isEnabled()) {
            CraftingManager.initCondenserRecipies();
        }
        if (BlockEnum.EMCCRAFTER.isEnabled()) {
            CraftingManager.initCrafterRecipies();
        }
        if (!ConfigManager.useEE3) {
            GameRegistry.addShapedRecipe((ItemStack)ItemEnum.EMCBOOK.getSizedStack(1), (Object[])new Object[]{" D ", "DBD", " D ", Character.valueOf('D'), dust, Character.valueOf('B'), Items.field_151122_aG});
        }
        CraftingManager.initCellRecipies();
    }

    private static void initCellRecipies() {
        int i;
        for (i = 0; i < 8; ++i) {
            GameRegistry.addShapelessRecipe((ItemStack)ItemEnum.EMCCELL.getDamagedStack(i), (Object[])new Object[]{ItemEnum.MISCITEM.getDamagedStack(0), ItemEnum.CELLCOMPONENT.getDamagedStack(i)});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemEnum.CELLCOMPONENT.getDamagedStack(0), new Object[]{"DCD", "CLC", "DCD", Character.valueOf('D'), dust, Character.valueOf('C'), quartzCrystals, Character.valueOf('L'), new ItemStack(aeMaterial, 1, 22)}));
        for (i = 1; i < 4; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)ItemEnum.CELLCOMPONENT.getDamagedStack(i), (Object[])new Object[]{"DCD", "SGS", "DSD", Character.valueOf('D'), dust, Character.valueOf('C'), new ItemStack(aeMaterial, 1, 23), Character.valueOf('S'), ItemEnum.CELLCOMPONENT.getDamagedStack(i - 1), Character.valueOf('G'), new ItemStack(aeGlass, 1)});
        }
        for (i = 4; i < 6; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)ItemEnum.CELLCOMPONENT.getDamagedStack(i), (Object[])new Object[]{"DED", "SGS", "DSD", Character.valueOf('D'), dust, Character.valueOf('E'), new ItemStack(aeMaterial, 1, 24), Character.valueOf('S'), ItemEnum.CELLCOMPONENT.getDamagedStack(i - 1), Character.valueOf('G'), new ItemStack(aeGlass, 1)});
        }
        for (i = 6; i < 8; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)ItemEnum.CELLCOMPONENT.getDamagedStack(i), (Object[])new Object[]{"NEN", "SGS", "NSN", Character.valueOf('N'), new ItemStack(Items.field_151156_bN), Character.valueOf('E'), new ItemStack(aeMaterial, 1, 24), Character.valueOf('S'), ItemEnum.CELLCOMPONENT.getDamagedStack(i - 1), Character.valueOf('G'), new ItemStack(aeGlass, 1)});
        }
        for (i = 0; i < 8; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemEnum.EMCCELL.getDamagedStack(i), new Object[]{"GRG", "RSR", "III", Character.valueOf('G'), new ItemStack(aeGlass, 1), Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), ItemEnum.CELLCOMPONENT.getDamagedStack(i), Character.valueOf('I'), "ingotIron"}));
        }
    }

    private static void initCrafterRecipies() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlockEnum.EMCCRAFTER.getBlock()), (Object[])new Object[]{"CDC", "DFD", "CDC", Character.valueOf('C'), base, Character.valueOf('D'), dust, Character.valueOf('F'), new ItemStack(aeMaterial, 1, 43)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(BlockEnum.EMCCRAFTER.getBlock(), 1, 1), new Object[]{"GGG", "GRG", "GGG", Character.valueOf('R'), new ItemStack(BlockEnum.EMCCRAFTER.getBlock()), Character.valueOf('G'), "gemDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(BlockEnum.EMCCRAFTER.getBlock(), 1, 2), new Object[]{"MMM", "MRM", "MMM", Character.valueOf('R'), new ItemStack(BlockEnum.EMCCRAFTER.getBlock(), 1, 1), Character.valueOf('M'), "gemEmerald"}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlockEnum.EMCCRAFTER.getBlock(), 1, 3), (Object[])new Object[]{"SSS", "SRS", "SSS", Character.valueOf('R'), new ItemStack(BlockEnum.EMCCRAFTER.getBlock(), 1, 2), Character.valueOf('S'), Items.field_151156_bN});
    }

    private static void initCondenserRecipies() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlockEnum.EMCCONDENSER.getBlock()), (Object[])new Object[]{"BDB", "BAB", "BDB", Character.valueOf('B'), base, Character.valueOf('D'), dust, Character.valueOf('A'), new ItemStack(aeMaterial, 1, 44)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(BlockEnum.EMCCONDENSER.getBlock(), 1, 1), new Object[]{"DDD", "DCD", "DDD", Character.valueOf('C'), new ItemStack(BlockEnum.EMCCONDENSER.getBlock()), Character.valueOf('D'), "gemDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(BlockEnum.EMCCONDENSER.getBlock(), 1, 2), new Object[]{"EEE", "ECE", "EEE", Character.valueOf('C'), new ItemStack(BlockEnum.EMCCONDENSER.getBlock(), 1, 1), Character.valueOf('E'), "gemEmerald"}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlockEnum.EMCCONDENSER.getBlock(), 1, 3), (Object[])new Object[]{"NNN", "NCN", "NNN", Character.valueOf('C'), new ItemStack(BlockEnum.EMCCONDENSER.getBlock(), 1, 2), Character.valueOf('N'), Items.field_151156_bN});
    }

    static {
        quartzCrystals = "EqECertusQuartz";
    }
}

