/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.tiles;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.security.MachineSource;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.AEProxy;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import net.minecraft.item.ItemStack;

public class CraftingJob {
    private double craftingTicks;
    private final ItemStack outputStack;
    private final AEProxy proxy;
    private final MachineSource source;
    private boolean finished;
    private final double cost;

    public CraftingJob(double craftingTicks, ItemStack outputStack, double cost, AEProxy proxy, MachineSource source) {
        this.craftingTicks = craftingTicks;
        this.outputStack = outputStack;
        this.proxy = proxy;
        this.source = source;
        this.cost = cost;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ItemStack getOutput() {
        return this.outputStack;
    }

    public double getCost() {
        return this.cost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean craftingTick() {
        if (this.craftingTicks <= 0.0) {
            ItemStack rejected = GridUtils.injectItems(this.proxy, this.outputStack, Actionable.SIMULATE, this.source);
            if (rejected != null && rejected.field_77994_a != 0) return false;
            GridUtils.injectItems(this.proxy, this.outputStack, Actionable.MODULATE, this.source);
            this.finished = true;
            return true;
        } else {
            double powerExtracted = GridUtils.extractAEPower(this.proxy, this.cost, Actionable.SIMULATE, PowerMultiplier.CONFIG) + 0.9;
            if (!(powerExtracted - this.cost >= 0.0)) return false;
            GridUtils.extractAEPower(this.proxy, this.cost, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.craftingTicks -= 1.0;
        }
        return true;
    }

    public double getRemainingTicks() {
        return this.craftingTicks;
    }
}

