/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Set;
import logisticspipes.asm.te.LPTileEntityObject;

public class CacheHolder {
    private final Table<CacheTypes, Object, Object> cache = HashBasedTable.create();

    public Object getCacheFor(CacheTypes type, Object key) {
        return this.cache.get((Object)type, key);
    }

    public void setCache(CacheTypes type, Object key, Object value) {
        this.cache.put((Object)type, key, value);
    }

    public void trigger(CacheTypes type) {
        if (type != null) {
            this.cache.row((Object)type).clear();
        } else {
            this.cache.clear();
        }
    }

    public static void clearCache(Set<LPTileEntityObject> toClear) {
        for (LPTileEntityObject obj : toClear) {
            obj.trigger(CacheTypes.Routing);
        }
    }

    public static enum CacheTypes {
        Routing,
        Inventory;

    }
}

