/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.api.CrucibleFormula;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.ICrucibleMold;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.tile.TileEntityMold;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.MutablePair;

public class TileEntityCrucible
extends TileEntity {
    public ArrayList<CrucibleLiquid> contents = new ArrayList();
    public HashMap<CrucibleLiquid, Integer> number = new HashMap();
    public boolean hasUpdated = true;
    public boolean needsUpdate = false;
    public int tipTicks = 0;
    private int targetFill = -1;
    private boolean tipping;
    private ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
    public boolean isPowered = false;
    private int lastComparatorOutput = 0;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = (NBTTagList)par1NBTTagCompound.func_74781_a("liquids");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(nbttagcompound1.func_74779_i("name"));
            if (liquid == null) continue;
            this.contents.add(liquid);
            this.number.put(liquid, Integer.valueOf(nbttagcompound1.func_74765_d("amount")));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (CrucibleLiquid liquid : this.contents) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74777_a("amount", (short)this.number.get(liquid).intValue());
            nbttagcompound1.func_74778_a("name", liquid.name);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("liquids", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound access = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        access.func_74768_a("tipTicks", this.tipTicks);
        access.func_74757_a("tipping", this.tipping);
        for (CrucibleLiquid liquid : this.contents) {
            if (liquid == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74777_a("amount", (short)this.number.get(liquid).intValue());
            nbttagcompound1.func_74778_a("name", liquid.name);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        access.func_74782_a("liquids", (NBTBase)nbttaglist);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        NBTTagList nbttaglist = (NBTTagList)access.func_74781_a("liquids");
        this.contents = new ArrayList();
        this.number = new HashMap();
        if (this.tipTicks == 0) {
            this.tipTicks = access.func_74762_e("tipTicks");
        }
        this.tipping = access.func_74767_n("tipping");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(nbttagcompound1.func_74779_i("name"));
            this.contents.add(liquid);
            this.number.put(liquid, Integer.valueOf(nbttagcompound1.func_74765_d("amount")));
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.targetFill < 0) {
            this.targetFill = this.getFill();
        }
        if (this.getFill() == this.targetFill) {
            this.hasUpdated = true;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.isPowered = true;
        }
        if (this.tipping || this.isPowered) {
            ICrucibleMold crucibleMold;
            CrucibleLiquid liquid;
            TileEntityMold mold;
            int posZ;
            int posX;
            ++this.tipTicks;
            if (this.tipTicks == 45 && !this.field_145850_b.field_72995_K && this.field_145850_b.func_147438_o(posX = this.field_145851_c + this.dirs[meta].offsetX, this.field_145848_d, posZ = this.field_145849_e + this.dirs[meta].offsetZ) != null && this.field_145850_b.func_147438_o(posX, this.field_145848_d, posZ) instanceof TileEntityMold && (mold = (TileEntityMold)this.field_145850_b.func_147438_o(posX, this.field_145848_d, posZ)).canPour() && this.contents.size() > 0 && (liquid = this.getNextLiquid(crucibleMold = (ICrucibleMold)mold.mold[0].func_77973_b())) != null) {
                if (!this.field_145850_b.field_72995_K) {
                    mold.pour(liquid);
                }
                int currNum = this.number.get(liquid);
                if ((currNum -= crucibleMold.getCostToMold(liquid)) == 0) {
                    this.contents.remove(liquid);
                }
                this.number.remove(liquid);
                if (currNum > 0) {
                    this.number.put(liquid, currNum);
                }
                this.needsUpdate = true;
            }
            if (this.tipTicks > 140) {
                this.tipTicks = 0;
                this.tipping = false;
                this.isPowered = false;
            }
        }
        for (CrucibleLiquid liquid : SteamcraftRegistry.liquids) {
            CrucibleFormula recipe;
            if (liquid.recipe == null || !(recipe = liquid.recipe).matches(this.contents, this.number, recipe)) continue;
            int currNum = this.number.get(recipe.liquid1);
            if ((currNum -= recipe.liquid1num) == 0) {
                this.contents.remove(recipe.liquid1);
            }
            this.number.remove(recipe.liquid1);
            this.number.put(recipe.liquid1, currNum);
            currNum = this.number.get(recipe.liquid2);
            if ((currNum -= recipe.liquid2num) == 0) {
                this.contents.remove(recipe.liquid2);
            }
            this.number.remove(recipe.liquid2);
            this.number.put(recipe.liquid2, currNum);
            if (!this.number.containsKey(liquid)) {
                this.contents.add(liquid);
                this.number.put(liquid, 0);
            }
            currNum = this.number.get(liquid);
            this.number.remove(liquid);
            this.number.put(liquid, currNum += recipe.output);
            this.needsUpdate = true;
        }
        if (this.getComparatorOutput() != this.lastComparatorOutput) {
            this.lastComparatorOutput = this.getComparatorOutput();
            this.func_70296_d();
        }
        if (this.needsUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.needsUpdate = false;
        }
    }

    public int getFill() {
        int fill = 0;
        for (CrucibleLiquid liquid : this.contents) {
            fill += this.number.get(liquid).intValue();
        }
        return fill;
    }

    public ItemStack fillWith(ItemStack stack, int amount, MutablePair output) {
        int fill = this.getFill();
        if (!this.field_145850_b.field_72995_K && fill + amount <= 90 && this.hasUpdated) {
            CrucibleLiquid fluid = (CrucibleLiquid)output.left;
            if (!this.contents.contains(fluid)) {
                this.contents.add(fluid);
                this.number.put(fluid, 0);
            }
            int currAmount = this.number.get(fluid);
            this.number.remove(fluid);
            this.number.put(fluid, currAmount += amount);
            --stack.field_77994_a;
            this.hasUpdated = false;
            this.targetFill = fill + amount;
            this.needsUpdate = true;
        }
        return stack;
    }

    public CrucibleLiquid getLiquidFromIngot(ItemStack ingot) {
        CrucibleLiquid output = null;
        for (CrucibleLiquid liquid : SteamcraftRegistry.liquids) {
            ItemStack ingotClone = ingot.func_77946_l();
            ingotClone.field_77994_a = 1;
            if (!liquid.ingot.equals(ingotClone)) continue;
            output = liquid;
            break;
        }
        return output;
    }

    public CrucibleLiquid getNextLiquid(ICrucibleMold mold) {
        for (CrucibleLiquid liquid : SteamcraftRegistry.liquids) {
            if (!this.number.containsKey(liquid) || !mold.canUseOn(liquid) || this.number.get(liquid) < mold.getCostToMold(liquid)) continue;
            return liquid;
        }
        return null;
    }

    public boolean isTipping() {
        return this.tipping && this.tipTicks <= 90;
    }

    public void setTipping() {
        this.tipping = true;
        this.tipTicks = 0;
    }

    public int getComparatorOutput() {
        return (int)(15.0 * ((double)this.getFill() / 90.0));
    }
}

