/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.tool.steam;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.api.IEngineerable;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.tool.ISteamTool;
import flaxbeard.steamcraft.api.tool.ISteamToolUpgrade;
import flaxbeard.steamcraft.api.tool.SteamToolSlot;
import flaxbeard.steamcraft.api.tool.UtilSteamTool;
import flaxbeard.steamcraft.gui.GuiEngineeringTable;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.tool.steam.ItemDrillHeadUpgrade;
import flaxbeard.steamcraft.item.tool.steam.SteamToolHelper;
import flaxbeard.steamcraft.misc.DrillHeadMaterial;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.commons.lang3.tuple.MutablePair;

public class ItemSteamDrill
extends ItemPickaxe
implements ISteamChargable,
IEngineerable,
ISteamTool {
    public IIcon[] coreIcons = new IIcon[2];
    public IIcon[] headIcons = new IIcon[2];
    private boolean hasBrokenBlock = false;
    public static final ResourceLocation largeIcons = new ResourceLocation("steamcraft:textures/gui/engineering2.png");
    private IdentityHashMap<ItemStack, MutablePair<Integer, Integer>> ticksSpeed = new IdentityHashMap();

    public ItemSteamDrill() {
        super(EnumHelper.addToolMaterial((String)"DRILL", (int)2, (int)320, (float)1.0f, (float)-1.0f, (int)0));
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack me, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(me, player, list, par4);
        list.add(EnumChatFormatting.WHITE + "" + (me.func_77958_k() - me.func_77960_j()) * this.steamPerDurability() + "/" + me.func_77958_k() * this.steamPerDurability() + " SU");
        ArrayList<ItemStack> upgradeStacks = UtilSteamTool.getUpgradeStacks(me);
        ArrayList<String> upgradeStrings = SteamToolHelper.getInformationFromStacks(upgradeStacks, SteamToolSlot.DRILL_HEAD, me);
        if (upgradeStrings == null) {
            return;
        }
        for (String string : upgradeStrings) {
            list.add(string);
        }
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        NBTTagCompound nbt = SteamToolHelper.checkNBT(stack);
        if (this.ticksSpeed.containsKey(stack)) {
            MutablePair<Integer, Integer> pair = this.ticksSpeed.get(stack);
            nbt.func_74768_a("Ticks", ((Integer)pair.getLeft()).intValue());
            nbt.func_74768_a("Speed", ((Integer)pair.getRight()).intValue());
            this.hasBrokenBlock = true;
            this.ticksSpeed.remove(stack);
        }
        return true;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound nbt = SteamToolHelper.checkNBT(stack);
        int which = nbt.func_74762_e("Ticks") > 50 ? 0 : 1;
        ArrayList<ISteamToolUpgrade> upgrades = UtilSteamTool.getUpgrades(stack);
        for (ISteamToolUpgrade upgrade : upgrades) {
            if (upgrade instanceof ItemDrillHeadUpgrade && upgrade.renderPriority() == renderPass) {
                return this.headIcons[which];
            }
            IIcon[] icons = upgrade.getIIcons();
            if (renderPass != upgrade.renderPriority() || icons == null || icons.length < which + 1 || icons[which] == null) continue;
            return icons[which];
        }
        return renderPass == 0 ? this.coreIcons[which] : this.headIcons[which];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack self, int renderPass) {
        ArrayList<ItemStack> upgrades = UtilSteamTool.getUpgradeStacks(self);
        for (ItemStack upgrade : upgrades) {
            if (!(upgrade.func_77973_b() instanceof ItemDrillHeadUpgrade) || ((ISteamToolUpgrade)upgrade.func_77973_b()).renderPriority() != renderPass) continue;
            String materialName = ItemDrillHeadUpgrade.getMyMaterial(upgrade);
            DrillHeadMaterial material = DrillHeadMaterial.materials.get(materialName);
            return material.getColorInt();
        }
        return super.func_82790_a(self, renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.coreIcons[0] = ir.func_94245_a("steamcraft:drillBaseCore0");
        this.coreIcons[1] = ir.func_94245_a("steamcraft:drillBaseCore1");
        this.headIcons[0] = ir.func_94245_a("steamcraft:drillBaseHead0");
        this.headIcons[1] = ir.func_94245_a("steamcraft:drillBaseHead1");
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (player instanceof EntityPlayer) {
            NBTTagCompound nbt = SteamToolHelper.checkNBT(stack);
            int ticks = nbt.func_74762_e("Ticks");
            int speed = nbt.func_74762_e("Speed");
            if (this.hasBrokenBlock) {
                speed -= 10;
                this.hasBrokenBlock = false;
            }
            int addedTicks = Math.min(Double.valueOf(Math.floor((double)speed / 1000.0 * 25.0)).intValue(), 50);
            ticks += addedTicks;
            if (this.isWound(stack)) {
                --speed;
            } else {
                ticks = ticks <= 0 ? 0 : --ticks;
            }
            ticks %= 100;
            if (((EntityLivingBase)player).field_82175_bq) {
                if (this.ticksSpeed.containsKey(stack)) {
                    this.ticksSpeed.get(stack).setLeft((Object)ticks);
                    this.ticksSpeed.get(stack).setRight((Object)speed);
                } else {
                    this.ticksSpeed.put(stack, (MutablePair<Integer, Integer>)MutablePair.of((Object)ticks, (Object)speed));
                }
            } else {
                nbt.func_74768_a("Ticks", ticks);
                nbt.func_74768_a("Speed", speed);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World par2World, EntityPlayer player) {
        NBTTagCompound nbt = SteamToolHelper.checkNBT(stack);
        int ticks = nbt.func_74762_e("Ticks");
        int speed = nbt.func_74762_e("Speed");
        boolean result = false;
        if (speed <= 1000) {
            speed += Math.min(90, 1000 - speed);
            result = this.addSteam(stack, -this.steamPerDurability(), player);
        }
        if (result) {
            nbt.func_74768_a("Ticks", ticks);
            nbt.func_74768_a("Speed", speed);
        }
        return stack;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return 1.0f;
    }

    @Override
    public int steamPerDurability() {
        return Config.steamToolConsumptionDrill;
    }

    @Override
    public boolean canCharge(ItemStack me) {
        return true;
    }

    @Override
    public boolean addSteam(ItemStack me, int amount, EntityPlayer player) {
        int trueAmount = -amount / this.steamPerDurability();
        int newAmount = me.func_77960_j() + trueAmount;
        if (newAmount <= 0) {
            me.func_77964_b(0);
            return false;
        }
        if (me.func_77958_k() >= newAmount) {
            me.func_77964_b(newAmount);
            return true;
        }
        if (amount < 0) {
            ItemStack chest = player.func_71124_b(3);
            if (chest == null || !(chest.func_77973_b() instanceof ItemExosuitArmor)) {
                return false;
            }
            ItemExosuitArmor armor = (ItemExosuitArmor)chest.func_77973_b();
            if (armor.hasPower(chest, amount)) {
                int exoAmount = -amount / armor.steamPerDurability();
                SteamcraftEventHandler.drainSteam(chest, exoAmount);
                return true;
            }
        }
        return false;
    }

    @Override
    public MutablePair<Integer, Integer>[] engineerCoordinates() {
        return SteamToolHelper.ENGINEER_COORDINATES;
    }

    @Override
    public ItemStack getStackInSlot(ItemStack me, int var1) {
        if (me.func_77942_o() && me.field_77990_d.func_74764_b("upgrades") && me.field_77990_d.func_74775_l("upgrades").func_74764_b(Integer.toString(var1))) {
            return ItemStack.func_77949_a((NBTTagCompound)me.field_77990_d.func_74775_l("upgrades").func_74775_l(Integer.toString(var1)));
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(ItemStack me, int var1, ItemStack stack) {
        SteamToolHelper.setNBTInventory(me, var1, stack);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack me, int var1, ItemStack var2) {
        return true;
    }

    @Override
    public ItemStack decrStackSize(ItemStack me, int var1, int var2) {
        if (this.getStackInSlot(me, var1) != null) {
            ItemStack stack;
            if (this.getStackInSlot((ItemStack)me, (int)var1).field_77994_a <= var2) {
                stack = this.getStackInSlot(me, var1);
                this.setInventorySlotContents(me, var1, null);
            } else {
                stack = this.getStackInSlot(me, var1).func_77979_a(var2);
                this.setInventorySlotContents(me, var1, this.getStackInSlot(me, var1));
                if (this.getStackInSlot((ItemStack)me, (int)var1).field_77994_a == 0) {
                    this.setInventorySlotContents(me, var1, null);
                }
            }
            return stack;
        }
        return null;
    }

    @Override
    public void drawSlot(GuiContainer gui, int slotnum, int i, int j) {
        gui.field_146297_k.func_110434_K().func_110577_a(GuiEngineeringTable.furnaceGuiTextures);
        switch (slotnum) {
            case 0: {
                gui.func_73729_b(i, j, 176, 0, 18, 18);
                break;
            }
            case 1: {
                gui.func_73729_b(i, j, 176, 0, 18, 18);
            }
        }
    }

    @Override
    public boolean canPutInSlot(ItemStack me, int slotNum, ItemStack upgrade) {
        if (upgrade != null && upgrade.func_77973_b() instanceof ISteamToolUpgrade) {
            ISteamToolUpgrade upgradeItem = (ISteamToolUpgrade)upgrade.func_77973_b();
            return upgradeItem.getToolSlot().tool == 0 && upgradeItem.getToolSlot().slot == slotNum || upgradeItem.getToolSlot() == SteamToolSlot.TOOL_CORE;
        }
        return false;
    }

    @Override
    public void drawBackground(GuiEngineeringTable guiEngineeringTable, int i, int j, int k) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(largeIcons);
        guiEngineeringTable.func_73729_b(j + 26, k + 3, 0, 128, 64, 64);
    }

    @Override
    public boolean isWound(ItemStack stack) {
        return SteamToolHelper.checkNBT(stack).func_74762_e("Speed") > 0;
    }

    @Override
    public boolean hasUpgrade(ItemStack me, Item check) {
        return UtilSteamTool.hasUpgrade(me, check);
    }

    @Override
    public String toolClass() {
        return "pickaxe";
    }
}

