/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api.steamnet;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.steamnet.data.SteamNetworkData;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

public class SteamNetworkRegistry {
    private static boolean loaderRegistered = false;
    private static SteamNetworkRegistry INSTANCE = new SteamNetworkRegistry();
    private HashSet<Integer> initialized = new HashSet();
    private HashMap<Integer, HashMap<String, SteamNetwork>> networks = new HashMap();

    public static SteamNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)new NetworkLoader());
            FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        }
    }

    public static void markDirty(SteamNetwork network) {
        World world = network.getWorld();
        if (world != null) {
            SteamNetworkData.get(world).func_76185_a();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, int dimID) {
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt, int dimID) {
        this.initialized.add(dimID);
    }

    public boolean isInitialized(int dim) {
        return this.initialized.contains(dim);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent e) {
        if (this.networks.values().size() > 0) {
            try {
                for (HashMap<String, SteamNetwork> dimension : this.networks.values()) {
                    for (SteamNetwork net : dimension.values()) {
                        if (net.tick()) continue;
                        dimension.remove(net.getName());
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    public SteamNetwork getNewNetwork() {
        SteamNetwork net = new SteamNetwork();
        String name = UUID.randomUUID().toString();
        net.setName(name);
        return net;
    }

    public void add(SteamNetwork network) {
        if (!this.networks.containsKey(network.getDimension())) {
            this.networks.put(network.getDimension(), new HashMap());
        }
        HashMap<String, SteamNetwork> dimension = this.networks.get(network.getDimension());
        dimension.put(network.getName(), network);
        World world = network.getWorld();
        if (world != null) {
            SteamNetworkData.get(world).func_76185_a();
        }
    }

    public void remove(SteamNetwork network) {
        if (this.networks.containsKey(network.getDimension())) {
            HashMap<String, SteamNetwork> dimension = this.networks.get(network.getDimension());
            dimension.remove(network.getName());
            World world = network.getWorld();
            if (world != null) {
                SteamNetworkData.get(world).func_76185_a();
            }
        }
    }

    public SteamNetwork getNetwork(String name, ISteamTransporter trans) {
        HashMap<String, SteamNetwork> dimension;
        int d = trans.getDimension();
        if (this.networks.containsKey(d) && (dimension = this.networks.get(trans.getDimension())).containsKey(name)) {
            return dimension.get(name);
        }
        return SteamNetwork.newOrJoin(trans);
    }

    public void printNetworks(int dim) {
        for (SteamNetwork net : this.networks.get(dim).values()) {
            Steamcraft.log.debug(net.getName());
        }
    }

    public void newDimension(int dimensionId) {
        this.initialized.add(dimensionId);
    }

    public static class NetworkLoader {
        @SubscribeEvent
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null && !event.world.field_72995_K) {
                int x = event.getChunk().field_76635_g;
                int z = event.getChunk().field_76647_h;
                IChunkProvider cProvider = event.getChunk().field_76637_e.func_72863_F();
                Chunk[] neighbors = new Chunk[5];
                neighbors[0] = event.getChunk();
                if (cProvider.func_73149_a(x + 1, z)) {
                    neighbors[1] = cProvider.func_73154_d(x + 1, z);
                }
                if (cProvider.func_73149_a(x - 1, z)) {
                    neighbors[2] = cProvider.func_73154_d(x - 1, z);
                }
                if (cProvider.func_73149_a(x, z + 1)) {
                    neighbors[3] = cProvider.func_73154_d(x, z + 1);
                }
                if (cProvider.func_73149_a(x, z - 1)) {
                    neighbors[4] = cProvider.func_73154_d(x, z - 1);
                }
                for (Chunk c : neighbors) {
                    this.refreshChunk(c);
                }
            }
        }

        public synchronized void refreshChunk(Chunk c) {
        }
    }
}

