/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.fluids;

import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.IGridProxyable;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.FluidHandler;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredFluidStack;
import sonar.core.integration.AE2Helper;

public class AE2FluidProvider
extends FluidHandler {
    public static String name = "AE2-Fluids";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    @Override
    public boolean canHandleFluids(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IGridProxyable;
    }

    @Override
    public InventoryHandler.StorageSize getFluids(List<StoredFluidStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        long maxStorage = 0L;
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IItemList fluids = storage.getFluidInventory().getStorageList();
            if (fluids == null) {
                return InventoryHandler.StorageSize.EMPTY;
            }
            for (IAEFluidStack fluid : fluids) {
                if (!fluid.isFluid() || fluid.getStackSize() == 0L) continue;
                SonarAPI.getFluidHelper().addFluidToList(storedStacks, AE2Helper.convertAEFluidStack((IAEStack)fluid));
                maxStorage += fluid.getStackSize();
            }
        }
        return new InventoryHandler.StorageSize(maxStorage, maxStorage);
    }

    @Override
    public StoredFluidStack addStack(StoredFluidStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IAEFluidStack fluid = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AE2Helper.convertStoredFluidStack(add), AE2Helper.getActionable(action), (BaseActionSource)new MachineSource((IActionHost)tile));
            if (fluid == null || fluid.getStackSize() == 0L) {
                return null;
            }
            return AE2Helper.convertAEFluidStack((IAEStack)fluid);
        }
        return add;
    }

    @Override
    public StoredFluidStack removeStack(StoredFluidStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            StoredFluidStack fluid = SonarAPI.getFluidHelper().getStackToAdd(remove.stored, remove, AE2Helper.convertAEItemStack(storage.getFluidInventory().extractItems((IAEStack)AE2Helper.convertStoredFluidStack(remove), AE2Helper.getActionable(action), (BaseActionSource)new MachineSource((IActionHost)tile))));
            if (fluid == null || fluid.stored == 0L) {
                return null;
            }
            return fluid;
        }
        return remove;
    }
}

