/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.EnergyType;
import sonar.core.api.SonarAPI;

public class StoredEnergyStack {
    public long stored;
    public long capacity;
    public long input;
    public long output;
    public long usage;
    public boolean hasStorage;
    public boolean hasInput;
    public boolean hasOutput;
    public boolean hasUsage;
    public EnergyType energyType;

    public StoredEnergyStack(EnergyType type) {
        this.energyType = type;
    }

    public void setStorageValues(long stored, long capacity) {
        if (!this.hasStorage) {
            this.stored = stored;
            this.capacity = capacity;
            this.hasStorage = true;
        }
    }

    public void increaseStorageValues(long stored, long capacity) {
        this.stored += stored;
        this.capacity += capacity;
    }

    public void setMaxInput(long input) {
        if (!this.hasInput) {
            this.input = input;
            this.hasInput = true;
        }
    }

    public void increaseMaxInput(long input) {
        this.input += input;
    }

    public void setMaxOutput(long output) {
        if (!this.hasOutput) {
            this.output = output;
            this.hasOutput = true;
        }
    }

    public void increaseMaxOutput(long output) {
        this.output += output;
    }

    public void setUsage(long usage) {
        if (!this.hasUsage) {
            this.usage = usage;
            this.hasUsage = true;
        }
    }

    public void increaseUsage(long usage) {
        this.usage += usage;
    }

    public static StoredEnergyStack readFromNBT(NBTTagCompound tag) {
        StoredEnergyStack stored = new StoredEnergyStack(SonarAPI.getRegistry().getEnergyType(tag.func_74779_i("energytype")));
        stored.hasStorage = tag.func_74767_n("hS");
        stored.hasInput = tag.func_74767_n("hI");
        stored.hasOutput = tag.func_74767_n("hO");
        stored.hasUsage = tag.func_74767_n("hU");
        if (stored.hasStorage) {
            stored.stored = tag.func_74763_f("s");
            stored.capacity = tag.func_74763_f("c");
        }
        if (stored.hasInput) {
            stored.input = tag.func_74763_f("i");
        }
        if (stored.hasOutput) {
            stored.output = tag.func_74763_f("o");
        }
        if (stored.hasUsage) {
            stored.usage = tag.func_74763_f("u");
        }
        return stored;
    }

    public static void writeToNBT(NBTTagCompound tag, StoredEnergyStack storedStack) {
        tag.func_74778_a("energytype", storedStack.energyType.getStorageSuffix());
        tag.func_74757_a("hS", storedStack.hasStorage);
        tag.func_74757_a("hI", storedStack.hasInput);
        tag.func_74757_a("hO", storedStack.hasOutput);
        tag.func_74757_a("hU", storedStack.hasUsage);
        if (storedStack.hasStorage) {
            tag.func_74772_a("s", storedStack.stored);
            tag.func_74772_a("c", storedStack.capacity);
        }
        if (storedStack.hasInput) {
            tag.func_74772_a("i", storedStack.input);
        }
        if (storedStack.hasOutput) {
            tag.func_74772_a("o", storedStack.output);
        }
        if (storedStack.hasUsage) {
            tag.func_74772_a("u", storedStack.usage);
        }
    }

    public static StoredEnergyStack readFromBuf(ByteBuf buf) {
        StoredEnergyStack stored = new StoredEnergyStack(SonarAPI.getRegistry().getEnergyType(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        stored.hasStorage = buf.readBoolean();
        stored.hasInput = buf.readBoolean();
        stored.hasOutput = buf.readBoolean();
        stored.hasUsage = buf.readBoolean();
        if (stored.hasStorage) {
            stored.stored = buf.readLong();
            stored.capacity = buf.readLong();
        }
        if (stored.hasInput) {
            stored.input = buf.readLong();
        }
        if (stored.hasOutput) {
            stored.output = buf.readLong();
        }
        if (stored.hasUsage) {
            stored.usage = buf.readLong();
        }
        return stored;
    }

    public static void writeToBuf(ByteBuf buf, StoredEnergyStack storedStack) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)storedStack.energyType.getStorageSuffix());
        buf.writeBoolean(storedStack.hasStorage);
        buf.writeBoolean(storedStack.hasInput);
        buf.writeBoolean(storedStack.hasOutput);
        buf.writeBoolean(storedStack.hasUsage);
        if (storedStack.hasStorage) {
            buf.writeLong(storedStack.stored);
            buf.writeLong(storedStack.capacity);
        }
        if (storedStack.hasInput) {
            buf.writeLong(storedStack.input);
        }
        if (storedStack.hasOutput) {
            buf.writeLong(storedStack.output);
        }
        if (storedStack.hasUsage) {
            buf.writeLong(storedStack.usage);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredEnergyStack) {
            StoredEnergyStack target = (StoredEnergyStack)obj;
            if (this.stored == target.stored && this.capacity == target.capacity && this.input == target.input && this.output == target.output && this.usage == target.usage && this.energyType.getStorageSuffix().equals(target.energyType.getStorageSuffix())) {
                return true;
            }
        }
        return false;
    }
}

