/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EnchantmentUtils {
    public static final int XP_PER_BOTTLE = 8;
    public static final int RATIO = 20;
    public static final int LIQUID_PER_XP_BOTTLE = 160;

    public static int calcEnchantability(ItemStack itemStack, int power, boolean max) {
        Item item = itemStack.func_77973_b();
        int k = item.func_77619_b();
        return EnchantmentUtils.calcEnchantability(k, power, max);
    }

    public static int calcEnchantability(int enchantability, int power, boolean max) {
        if (enchantability <= 0) {
            return 0;
        }
        if (power > 15) {
            power = 15;
        }
        int l = (max ? 7 : 0) + 1 + (power >> 1) + (max ? power : 0);
        return max ? Math.max(l, power * 2) : Math.max(l / 3, 1);
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.field_71068_ca = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static boolean enchantItem(ItemStack itemstack, int level, Random rand) {
        boolean isBook;
        if (itemstack == null) {
            return false;
        }
        List enchantments = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)itemstack, (int)level);
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        boolean bl = isBook = itemstack.func_77973_b() == Items.field_151122_aG;
        if (isBook) {
            itemstack.func_150996_a((Item)Items.field_151134_bR);
            int count = enchantments.size();
            int ignored = count > 1 ? rand.nextInt(count) : -1;
            for (int i = 0; i < count; ++i) {
                if (i == ignored) continue;
                Items.field_151134_bR.func_92115_a(itemstack, (EnchantmentData)enchantments.get(i));
            }
        } else {
            for (EnchantmentData enchantment : enchantments) {
                itemstack.func_77966_a(enchantment.field_76302_b, enchantment.field_76303_c);
            }
        }
        return true;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (EnchantmentUtils.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static float getPower(World worldObj, int xCoord, int yCoord, int zCoord) {
        float power = 0.0f;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int innerX = xCoord + z;
                int innerZ = zCoord + x;
                int outerX = xCoord + z * 2;
                int outerZ = zCoord + x * 2;
                int middle = yCoord;
                int top = yCoord + 1;
                if (x == 0 && z == 0 || !worldObj.func_147437_c(innerX, middle, innerZ) || !worldObj.func_147437_c(innerX, top, innerZ)) continue;
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)outerX, (int)middle, (int)outerZ);
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)outerX, (int)top, (int)outerZ);
                if (z == 0 || x == 0) continue;
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)outerX, (int)middle, (int)innerZ);
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)outerX, (int)top, (int)innerZ);
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)innerX, (int)middle, (int)outerZ);
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)innerX, (int)top, (int)outerZ);
            }
        }
        return power;
    }

    public static int liquidToXPRatio(int liquid) {
        return liquid / 20;
    }

    public static int XPToLiquidRatio(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return EnchantmentUtils.XPToLiquidRatio(EnchantmentUtils.getExperienceForLevel(level));
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            items.add(Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i)));
        }
    }
}

