/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.collect.Iterators;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;
import openmods.utils.DirUtils;
import openmods.utils.bitmap.IBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;

public class SyncableDirs
extends SyncableObjectBase
implements IRpcDirectionBitMap,
IBitMap<ForgeDirection>,
ISyncableValueProvider<Set<ForgeDirection>> {
    private Set<ForgeDirection> dirs = EnumSet.noneOf(ForgeDirection.class);

    private void read(int bits) {
        this.dirs.clear();
        Iterators.addAll(this.dirs, DirUtils.bitsToValidDirs(bits));
    }

    private int write() {
        return ByteUtils.enumSetToBits(this.dirs);
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.read(stream.readByte());
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeByte(this.write());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74774_a(name, (byte)this.write());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.read(nbt.func_74771_c(name));
    }

    @Override
    public Set<ForgeDirection> getValue() {
        return Collections.unmodifiableSet(this.dirs);
    }

    @Override
    public void mark(ForgeDirection dir) {
        if (this.dirs.add(dir)) {
            this.markDirty();
        }
    }

    @Override
    public void clear(ForgeDirection dir) {
        if (this.dirs.remove(dir)) {
            this.markDirty();
        }
    }

    @Override
    public boolean get(ForgeDirection dir) {
        return this.dirs.contains(dir);
    }

    @Override
    public void clearAll() {
        this.dirs.clear();
        this.markDirty();
    }

    @Override
    public void toggle(ForgeDirection value) {
        if (!this.dirs.remove(value)) {
            this.dirs.add(value);
        }
        this.markDirty();
    }

    @Override
    public void set(ForgeDirection key, boolean value) {
        if (value) {
            this.dirs.add(key);
        } else {
            this.dirs.remove(key);
        }
        this.markDirty();
    }
}

